/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Device Driver Register Definitions
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2005-2006 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _FPD_INTR_H_
#define _FPD_INTR_H_

#include "fpd.h"
#include "fpd_reg.h"

static inline void fpd_enable_interrupt( fpd_device_t *pfpd )
{
    u32 reg;

    /* set Global Interrupt Enable bit */
    reg = FPD_READ(pfpd->remap, FPD_GLOBAL_CONTROL);
    reg |= GCR_GIE;
    FPD_WRITE(pfpd->remap, FPD_GLOBAL_CONTROL, reg);

    return;
}

static inline void fpd_disable_interrupt( fpd_device_t *pfpd )
{
    u32 reg;

    /* clear Global Interrupt Enable bit */
    reg = FPD_READ(pfpd->remap, FPD_GLOBAL_CONTROL);
    reg &= ~GCR_GIE;
    FPD_WRITE(pfpd->remap, FPD_GLOBAL_CONTROL, reg);

    return;
}

#endif /* _FPD_INTR_H_ */
