/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Device Driver Protocol Data Header File
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential
 * proprietary information distributed solely pursuant to a confidentiality
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _FPD_PDATA_H_
#define _FPD_PDATA_H_

#include <asm/atomic.h>
#include "fpd_lock.h"

#define FPD_PDATA_BUFFER_SIZE                  8192
//#define FPD_PDATA_BUFFER_SIZE                  32

typedef enum
{
    USER_SPACE = 1,
    KERNEL_SPACE
} bufloc_t;

typedef struct {
    u32                    link_if;
    u32                    btype;

    fpd_lock_t             tx_lock;
    u8                    *txbuf;
    u8                    *txbuf_rdptr;
    u8                    *txbuf_wrptr;
    u8                    *txbuf_end;
    u32                    txbuf_bytes_left;
    atomic_t               req_tx;

    fpd_lock_t             rx_lock;
    u8                    *rxbuf;
    u8                    *rxbuf_rdptr;
    u8                    *rxbuf_wrptr;
    u8                    *rxbuf_end;
    u32                    rxbuf_bytes_unused;
    atomic_t               rxbuf_no_space;

    void                  *private;
} fpd_pdata_t;

extern int  pdata_init( fpd_pdata_t *pcim, u32 link_if, u32 btype, void *parg );
extern int  pdata_cleanup( fpd_pdata_t *pcim );
extern int  pdata_reset( fpd_pdata_t *pcim );
extern int  pdata_check_events( fpd_pdata_t *pcim );
extern int  pdata_disconnect_check( fpd_pdata_t *pcim );
extern int  pdata_write( fpd_pdata_t *pcim, int len, const u8 *appbuf, bufloc_t bufloc );
extern int  pdata_read( fpd_pdata_t *pcim, int len, u8 *appbuf );
extern int  pdata_transmit( fpd_pdata_t *pcim );
extern int  pdata_receive( fpd_pdata_t *pcim );

#endif /* _FPD_PDATA_H */
