/******************************************************************************
 *  MODULE:           FPGA PROTOCOL
 ******************************************************************************
 *
 *  FPGA Protocol Driver Timer Utilities
 *
 *  FILE:             $Workfile$
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2005-2006 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#ifndef _FPD_TIMER_H_
#define _FPD_TIMER_H_

#define WAIT_100MS                   100
#define WAIT_200MS                   200
#define WAIT_500MS                   500
#define WAIT_1SEC                    1000
#define WAIT_2SEC                    2000

typedef struct {
    u32                timeout_value;
    atomic_t           running;
    struct timer_list  tlist;
    wait_queue_head_t  wait_queue;
    void              *private;
} fpd_timer_t;

void fpd_setup_timer( fpd_timer_t *ptimer );
void fpd_modify_timer( fpd_timer_t *ptimer );
void fpd_cleanup_timer( fpd_timer_t *ptimer );

#endif /* _FPD_TIMER_H_ */
