#ifndef _GPIO_HILEVEL_H
#define _GPIO_HILEVEL_H

#include <pp_gpio.h>

/* GPIO bit definitions */
#ifdef PP_BOARD_KIRA
# define PP_GPIO_ATMEL_DEVNAME		"/dev/gpio-faraday"
# define PP_GPIO_ATMEL_DEV		PP_GPIO_DEV_FARADAY
# define PP_GPIO_ATMEL_MISO		PP_GPIO_BIT(5)
# define PP_GPIO_ATMEL_MOSI		PP_GPIO_BIT(4)
# define PP_GPIO_ATMEL_RST		PP_GPIO_BIT(7)
# define PP_GPIO_ATMEL_SCK		PP_GPIO_BIT(6)
# define PP_GPIO_HOST_DEV		PP_GPIO_DEV_FARADAY
# if defined (PRODUCT_ASMIDC) 
#  define PP_GPIO_HOST_ATX		PP_GPIO_BIT(9)
#  define PP_GPIO_HOST_RST		PP_GPIO_BIT(12)
# else
#  define PP_GPIO_HOST_ATX		PP_GPIO_BIT(1)
#  define PP_GPIO_HOST_RST		PP_GPIO_BIT(2)
# endif
# define PP_GPIO_SERIAL_MODE_DEV	PP_GPIO_DEV_FARADAY
# define PP_GPIO_SERIAL_MODE		PP_GPIO_BIT(2)
# if defined(PP_FEAT_PSU_ADAPT) /* added for eRIC G4*/
#  define PP_GPIO_PSU_DEV		PP_GPIO_DEV_FARADAY
#  define PP_GPIO_PSU_STDBY		PP_GPIO_BIT(8)
#  define PP_GPIO_PSU_ONOFF		PP_GPIO_BIT(13)
#  define PP_GPIO_PSU_ISOLATE		PP_GPIO_BIT(11)
# endif
# if defined(PP_FEAT_RESET_TO_DEFAULTS_PINS)
#  define PP_GPIO_DEFAULTS_DEV		PP_GPIO_DEV_FARADAY
#  if defined (PRODUCT_ASMIDC)
#   define PP_GPIO_DEFAULTS		PP_GPIO_BIT(8)
#  elif defined (PRODUCT_ERICG4)
#   define PP_GPIO_DEFAULTS		PP_GPIO_BIT(10)
#  endif
# endif
#else /* !PP_BOARD_KIRA */
# define PP_GPIO_ATMEL_DEVNAME		"/dev/gpio-ibm"
# define PP_GPIO_ATMEL_DEV		PP_GPIO_DEV_IBM
# define PP_GPIO_ATMEL_MISO		PP_IBM_GPIO_BIT(1)
# define PP_GPIO_ATMEL_MOSI		PP_IBM_GPIO_BIT(2)	/* also input to FPGA_DATA0 */
# define PP_GPIO_ATMEL_RST		PP_IBM_GPIO_BIT(3)
# define PP_GPIO_ATMEL_SCK		PP_IBM_GPIO_BIT(4)	/* also input to FPGA_DCLK */
# define PP_GPIO_HOST_DEV		PP_GPIO_DEV_IBM
# define PP_GPIO_HOST_ATX		PP_IBM_GPIO_BIT(7)
# define PP_GPIO_HOST_RST		PP_IBM_GPIO_BIT(6)
# define PP_GPIO_SERIAL_MODE_DEV	PP_GPIO_DEV_IBM
# define PP_GPIO_SERIAL_MODE		PP_IBM_GPIO_BIT(6)
# if defined(PP_FEAT_PSU_ADAPT) /* added for eRIC G4*/
#  define PP_GPIO_PSU_DEV		PP_GPIO_DEV_IBM
#  define PP_GPIO_PSU_STDBY		PP_IBM_GPIO_BIT(19)
#  define PP_GPIO_PSU_ONOFF		PP_IBM_GPIO_BIT(21)
#  define PP_GPIO_PSU_ISOLATE		PP_IBM_GPIO_BIT(23)
# endif
#endif /* !PP_BOARD_KIRA */

#if defined(PP_FEAT_AD_ATMEL)
# define PP_GPIO_ATMEL_AD_RST		PP_IBM_GPIO_BIT(5)
# define PP_GPIO_ATMEL_AD_MOSI		PP_IBM_GPIO_BIT(19)
# define PP_GPIO_ATMEL_AD_MISO		PP_IBM_GPIO_BIT(21)
# define PP_GPIO_ATMEL_AD_SCK		PP_IBM_GPIO_BIT(23)
#else
# define PP_GPIO_DEFAULT_JUMPER		PP_IBM_GPIO_BIT(5)
/* input to check external power supply */
# ifdef PP_BOARD_KIRA
#  define PP_GPIO_EXT_POWER_STATUS_DEV	PP_GPIO_DEV_FARADAY
#  define PP_GPIO_EXT_POWER_STATUS	PP_GPIO_BIT(11)	
# else
#  define PP_GPIO_EXT_POWER_STATUS_DEV	PP_GPIO_DEV_IBM
#  define PP_GPIO_EXT_POWER_STATUS	PP_IBM_GPIO_BIT(23)
# endif
#endif

#ifdef PP_BOARD_KIRA
# define PP_GPIO_FPGA_DEVNAME		"/dev/gpio-faraday"
# define PP_GPIO_FPGA_DEV		PP_GPIO_DEV_FARADAY
# define PP_GPIO_FPGA_TDI		PP_GPIO_BIT(29)	/* output to FPGA TDI input */
# define PP_GPIO_FPGA_TCK		PP_GPIO_BIT(30)	/* output to FPGA TCK input */
# define PP_GPIO_FPGA_TMS		PP_GPIO_BIT(28)	/* output to FPGA TMS input */
# define PP_GPIO_FPGA_TDO		PP_GPIO_BIT(31)	/* input  to FPGA TDO output*/
#elif defined(PRODUCT_KX2)
# define PP_GPIO_FPGA_DEVNAME          "/dev/gpio-ibm"
# define PP_GPIO_FPGA_DEV              PP_GPIO_DEV_IBM
# define PP_GPIO_FPGA_TDI              PP_IBM_GPIO_BIT(5)      /* output to FPGA TDI input */
# define PP_GPIO_FPGA_TCK              PP_IBM_GPIO_BIT(9)      /* output to FPGA TCK input */
# define PP_GPIO_FPGA_TMS              PP_IBM_GPIO_BIT(23)     /* output to FPGA TMS input */
# define PP_GPIO_FPGA_TDO              PP_IBM_GPIO_BIT(4)      /* input  to FPGA TDO output*/
#else
# define PP_GPIO_FPGA_DEVNAME		"/dev/gpio-ibm"
# define PP_GPIO_FPGA_DEV		PP_GPIO_DEV_IBM
# define PP_GPIO_FPGA_TDI		PP_IBM_GPIO_BIT(2)	/* output to FPGA TDI input */
# define PP_GPIO_FPGA_TCK		PP_IBM_GPIO_BIT(4)	/* output to FPGA TCK input */
# define PP_GPIO_FPGA_TMS		PP_IBM_GPIO_BIT(8)	/* output to FPGA TMS input */
# define PP_GPIO_FPGA_TDO		PP_IBM_GPIO_BIT(20)	/* input  to FPGA TDO output*/
#endif

#ifdef PRODUCT_XX01IP_ANY
# define PP_GPIO_LED2			PP_IBM_GPIO_BIT(9)
#endif

#define PP_GPIO_ATMEL_EXTIRQ		PP_IBM_GPIO_BIT(8)
#define PP_GPIO_UART1_EXT		PP_IBM_GPIO_BIT(9)

#define PP_GPIO_IPM220_PWR		PP_IBM_GPIO_BIT(27)  /* switches IPM220 GPIO (UART0_DTR) */

#if defined(PRODUCT_KIMTESTERMST)
# define PP_GPIO_KTST_DEV                PP_GPIO_DEV_IBM
/* powers the slave on/off */
# define PP_GPIO_POWER_SLV		PP_IBM_GPIO_BIT(5)
/* buttons used as switches */
# define PP_GPIO_SW_1			PP_IBM_GPIO_BIT(7)
# define PP_GPIO_SW_2			PP_IBM_GPIO_BIT(6)
# define PP_GPIO_SW_3			PP_IBM_GPIO_BIT(9)
#endif

#if defined(PRODUCT_KX2)
# define PP_GPIO_BUZZER			PP_IBM_GPIO_BIT(3)
# define PP_GPIO_GBIT_SELECT		PP_IBM_GPIO_BIT(6)
#endif

#endif /* _GPIO_HILEVEL_H */
