#ifndef __I2C_DEBUG_H
#define __I2C_DEBUG_H

/* module global debug level */
#if !defined DBG_LEVEL
# define DBG_LEVEL 0
#endif

/* debug prints */
#if DBG_LEVEL > 0
#  define I2C_DBG(mod, fmt, x...)	printk(mod ": " fmt, ##x)
#else
#  define I2C_DBG(mod, fmt, x...)	((void)0)
#endif
#if DBG_LEVEL > 1
#  define I2C_DBG2(mod, fmt, x...) 	I2C_DBG( mod, fmt, ##x )
#else
#  define I2C_DBG2(mod, fmt, x...) 	((void)0)
#endif

/* dump a buffer */
#if DBG_LEVEL > 2
static void
dump_iic_buf(const char* string, const char* buf, int len)
{
	int i;
	printk(KERN_DEBUG "%s: Bytes:\n", string);
	for (i = 0; i < len; i++) {
		printk(KERN_DEBUG"0x%02x\n", buf[i] & 0xff);
	}
}
#  define DUMP_BUF(s, buf,len)	dump_iic_buf((s),(buf),(len))
#else
#  define DUMP_BUF(s, buf,len)	((void)0)
#endif

/* warning prints */
#define I2C_WARN(mod, fmt, x...)	printk(KERN_WARNING mod ": " fmt, ##x)

#endif /* __I2C_DEBUG_H */

