#ifndef __RINGBUFFER_H
#define __RINGBUFFER_H

/* This file defines a ring buffer to store data */

/* Constants */
#define BUFFER_ENTRIES		32
#define BUFFER_ENTRYSIZE	512

/* ring buffer structure */
struct ringbuffer {
	char buffer[BUFFER_ENTRIES][BUFFER_ENTRYSIZE];
	int len[BUFFER_ENTRIES];

	int buf_in;	/* position of the next entry to write */
	int buf_out;	/* position of the next entry to read */
	int no_buf;	/* number of entries in the buffer */
	
	int ignore_overflow;
		/* flag: write into the buffer even when it is full;
		   the oldest entry will be removed */
};

/* ring buffer functions */

/* (re)initialize the ring buffer */
void ringbuffer_init(struct ringbuffer* buffer, int allow_overflow);

/* get the current entry from the buffer */
int ringbuffer_get_entry(struct ringbuffer* buffer, char* data, int* len);

/* put an entry into the buffer at the current position */
int ringbuffer_put_entry(struct ringbuffer* buffer, char* data, int* len);

/* get the status of the ring buffer */
int ringbuffer_is_full(struct ringbuffer* buffer);
int ringbuffer_is_empty(struct ringbuffer* buffer);


#endif /* __RINGBUFFER_H */
