/**
 * lpc_bt.h
 *
 * KIRA100 LPC (slave) core driver for Block Transfer protocol
 *
 * (c) 2004 Peppercon AG, Ralf Guenther <rgue@peppercon.de>
 */

#ifndef __LPC_BT_H__
#define __LPC_BT_H__

#include "lpc_core.h"

int bt_init(lpc_t *lpc, int chan, uint16_t host_io_base, wait_queue_head_t *wait, void **pbt_data);
int bt_cleanup(void *bt_data);

int bt_start(void *bt_data);
int bt_stop(void *bt_data);

int bt_read(void *bt_data, uint8_t *buf, int size);
int bt_write(void *bt_data, const uint8_t *buf, int size);

int bt_can_read(void *bt_data);
int bt_can_write(void *bt_data);

int bt_host_atn(void *bt_data, int set);

int bt_event(void *bt_data);

#endif /* !__LPC_BT_H__ */
