#ifndef _PP_BYTE_ORDER_H
#define _PP_BYTE_ORDER_H
/*
 * byte order independent bitfields
 */

#define __BO_BE 1
#define __BO_LE 2

#ifdef __KERNEL__
# include <asm/byteorder.h>
# ifdef __BIG_ENDIAN
#  define __BO__ __BO_BE
# elif __LITTLE_ENDIAN
#  define __BO__ __BO_LE
# else
#  error no endianess defined in kernel
# endif
#else /* user space */
# include <endian.h>
# if __BYTE_ORDER == __BIG_ENDIAN
#  define __BO__ __BO_BE
# elif __BYTE_ORDER == __LITTLE_ENDIAN
#  define __BO__ __BO_LE
# endif
#endif

#if __BO__ == __BO_BE
#define BITFIELD1(type, val1) \
    type val1

#define BITFIELD2(type, val1, val2) \
    type val2; \
    type val1
    
#define BITFIELD3(type, val1, val2, val3) \
    type val3; \
    type val2; \
    type val1
    
#define BITFIELD4(type, val1, val2, val3, val4) \
    type val4; \
    type val3; \
    type val2; \
    type val1

#define BITFIELD5(type, val1, val2, val3, val4, val5)	\
    type val5; \
    type val4; \
    type val3; \
    type val2; \
    type val1

#define BITFIELD6(type, val1, val2, val3, val4, val5, val6)	\
    type val6; \
    type val5; \
    type val4; \
    type val3; \
    type val2; \
    type val1

#define BITFIELD7(type, val1, val2, val3, val4, val5, val6, val7)	\
    type val7; \
    type val6; \
    type val5; \
    type val4; \
    type val3; \
    type val2; \
    type val1

#define BITFIELD8(type, val1, val2, val3, val4, val5, val6, val7, val8)	\
    type val8; \
    type val7; \
    type val6; \
    type val5; \
    type val4; \
    type val3; \
    type val2; \
    type val1

#elif __BO__ == __BO_LE

#define BITFIELD1(type, val1) \
    type val1

#define BITFIELD2(type, val1, val2) \
    type val1; \
    type val2
    
#define BITFIELD3(type, val1, val2, val3) \
    type val1; \
    type val2; \
    type val3
    
#define BITFIELD4(type, val1, val2, val3, val4) \
    type val1; \
    type val2; \
    type val3; \
    type val4

#define BITFIELD5(type, val1, val2, val3, val4, val5) \
    type val1; \
    type val2; \
    type val3; \
    type val4; \
    type val5

#define BITFIELD6(type, val1, val2, val3, val4, val5, val6) \
    type val1; \
    type val2; \
    type val3; \
    type val4; \
    type val5; \
    type val6

#define BITFIELD7(type, val1, val2, val3, val4, val5, val6, val7) \
    type val1; \
    type val2; \
    type val3; \
    type val4; \
    type val5; \
    type val6; \
    type val7

#define BITFIELD8(type, val1, val2, val3, val4, val5, val6, val7, val8)	\
    type val1; \
    type val2; \
    type val3; \
    type val4; \
    type val5; \
    type val6; \
    type val7; \
    type val8

#endif

#endif /* _PP_BYTE_ORDER_H */
