#ifndef __TCO_CORE_H__
#define __TCO_CORE_H__

#include <linux/types.h>
#include <linux/wait.h>
#include <linux/threads.h>
#include <linux/interrupt.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>

/*
 * data
 */
typedef struct tco_s tco_t;

struct tco_s {
    char            name[10];
    int             initialized;
    int             max_data_size;
    unsigned char   slave_addr;

    /* initialize/cleanup on module loading; must not be NULL */
    int (* init)(struct net_device *dev, tco_t *tco);
    void (* cleanup)(tco_t *tco);

    /* initialize core on first usage, cleanup core on last usage; may be NULL */
    int (* core_init)(struct net_device *dev, tco_t *tco);
    void (* core_release)(struct net_device *dev, tco_t *tco);

    /* enable/disable client interrupt; must not be NULL */
    void (* enable_client_int)(tco_t *tco, int enable);

    /* check if int was raised by tco (don't called from IRQ level!) */
    int (* check_int_source)(tco_t *tco);

    /* block read/write; must not be NULL */
    int (* write_block)(tco_t *tco,
		        u8 command,
		        u8 byte_count,
		        const u8 * data);
    int (* read_block)(tco_t *tco,
		       u8 command,
		       u8 *byte_count,
		       u8 *data);

    /* read/write a register; may ne NULL */
    u32 (* read_reg)(tco_t *tco, u32 offset);
    void (* write_reg)(tco_t *tco, u32 offset, u32 val);
};

extern tco_t *tco;

// prototype of callback at interrupt time, to be implemented by module
int tco_recv_cb(tco_t *tco); 

#endif /* !__TCO_CORE_H__ */
