#!/bin/sh
echo "Testing FML core register access..."

peek d 0x92000000 16 > /dev/null
peek d 0x92001000 16 > /dev/null

echo "  checking magic..."

if ! peek d 0x92000018 1 | grep "^92000018: 464d4c2d " > /dev/null; then
echo "ERROR: failed to read magic (1st byte (92000018) != 'FML-')"
exit 0
fi
if ! peek d 0x9200001c 1 | grep "^9200001c: 436f7265 " > /dev/null; then
echo "ERROR: failed to read magic (2nd byte (9200001c) != 'core')"
exit 0
fi

echo "  resetting core..."
poke d 0x92000000 2
poke d 0x92000000 0

echo "  checking register read..."

# make some stress
peek d 0x92000000 16 > /dev/null
peek d 0x92000000 16 > /dev/null
peek d 0x92000000 16 > /dev/null
peek d 0x92000000 16 > /dev/null
peek d 0x92000000 16 > /dev/null

if ! peek d 0x9200000c 1 | grep "^9200000c: 00000000 " > /dev/null; then
echo "ERROR: failed to read register (status (9200000c) != 0)"
exit 0
fi

echo "  checking register write..."

poke d 0x92000010 0xa5 > /dev/null

if ! peek d 0x92000010 1 | grep "^92000010: 000000a5 " > /dev/null; then
echo "ERROR: failed to write register (prescale (92000010) != a5)"
exit 0
fi

echo "  checking buffer read..."

peek d 0x92001000 0x400 > /dev/null

echo "  checking buffer write..."

poke d 0x92001000 0x12345678 0x400 > /dev/null

if ! peek d 0x92001000 1 | grep "^92001000: 12345678 " > /dev/null; then
echo "ERROR: failed to write memory (begin of write buffer (92001000) != 12345678)"
exit 0
fi
if ! peek d 0x920017fc 1 | grep "^920017fc: 12345678 " > /dev/null; then
echo "ERROR: failed to write memory (end of write buffer (920017fc) != 12345678)"
exit 0
fi

if ! peek d 0x92001800 1 | grep "^92001800: 00000000 " > /dev/null; then
echo "ERROR: unexpected memory content (begin of read buffer (92001800) != 0)"
exit 0
fi
if ! peek d 0x92001ffc 1 | grep "^92001ffc: 00000000 " > /dev/null; then
echo "ERROR: unexpected memory content (end of read buffer (920018fc) != 0)"
exit 0
fi

echo "Success. (if you don't see any errors above)"
