#ifndef _CHAP9_H
#define _CHAP9_H

#include <linux/types.h>
#include "pp_usb.h"

extern volatile usb_device_state_t g_DeviceState;

#define USB_REQUEST_DIR_MASK     (uint8_t)0x80


#define USB_REQUEST_TYPE_MASK    (uint8_t)0x60

#define USB_STANDARD_REQUEST     (uint8_t)0x00
#define USB_CLASS_REQUEST        (uint8_t)0x20
#define USB_VENDOR_REQUEST       (uint8_t)0x40


#define USB_REQUEST_MASK         (uint8_t)0xff

#define USB_RECIPIENT_MASK        (uint8_t)0x1F

#define USB_RECIPIENT_DEVICE     (uint8_t)0x00
#define USB_RECIPIENT_INTERFACE  (uint8_t)0x01
#define USB_RECIPIENT_ENDPOINT   (uint8_t)0x02

void Chap9_busreset(void);
void Chap9_StallEP0(void);
void Chap9_GetStatus(void);
void Chap9_ClearFeature(void);
void Chap9_SetFeature(void);
void Chap9_SetAddress(void);
void Chap9_GetConfiguration(void);
void Chap9_SetConfiguration(void);
void Chap9_GetInterface(void);
void Chap9_SetInterface(void);
void Chap9_GetDescriptor(void);

void Chap9_StallEP0InControlWrite(void);
void Chap9_StallEP0InControlRead(void);
void Chap9_SingleTransmitEP0(const uint8_t* buf, const uint16_t len);
void Chap9_BurstTransmitEP0(const uint8_t * pRomData, const uint16_t len);


#pragma pack(1)
typedef struct {
    unsigned char bmRequestType;
    unsigned char bRequest;
    unsigned short wValue;
    unsigned short wIndex;
    unsigned short wLength;
} USB_SETUP_REQUEST, *PUSB_SETUP_REQUEST;

typedef struct {
    unsigned char bLength;
    unsigned char bDescriptorType;
    unsigned short bcdUSB;
    unsigned char bDeviceClass;
    unsigned char bDeviceSubClass;
    unsigned char bDeviceProtocol;
    unsigned char bMaxPacketSize0;
    unsigned short idVendor;
    unsigned short idProduct;
    unsigned short bcdDevice;
    unsigned char iManufacturer;
    unsigned char iProduct;
    unsigned char iSerialNumber;
    unsigned char bNumConfigurations;
} USB_DEVICE_DESCRIPTOR, *PUSB_DEVICE_DESCRIPTOR;

typedef struct {
    unsigned char bLength;
    unsigned char bDescriptorType;
    unsigned char bEndpointAddress;
    unsigned char bmAttributes;
    unsigned short wMaxPacketSize;
    unsigned char bInterval;
} USB_ENDPOINT_DESCRIPTOR, *PUSB_ENDPOINT_DESCRIPTOR;

typedef struct {
    unsigned char bLength;
    unsigned char bDescriptorType;
    unsigned short wTotalLength;
    unsigned char bNumInterfaces;
    unsigned char bConfigurationValue;
    unsigned char iConfiguration;
    unsigned char bmAttributes;
    unsigned char MaxPower;
} USB_CONFIGURATION_DESCRIPTOR, *PUSB_CONFIGURATION_DESCRIPTOR;

typedef struct {
    unsigned char bLength;
    unsigned char bDescriptorType;
    unsigned char bInterfaceNumber;
    unsigned char bAlternateSetting;
    unsigned char bNumEndpoints;
    unsigned char bInterfaceClass;
    unsigned char bInterfaceSubClass;
    unsigned char bInterfaceProtocol;
    unsigned char iInterface;
} USB_INTERFACE_DESCRIPTOR, *PUSB_INTERFACE_DESCRIPTOR;

typedef struct {
    unsigned char bLength;
    unsigned char bDescriptorType;
    unsigned short wHIDClassSpecComp;
    unsigned char bCountry;
    unsigned char bNumDescriptors;
    unsigned char b1stDescType;
    unsigned short w1stDescLength;
} USB_HID_DESCRIPTOR, *PUSB_HID_DESCRIPTOR;

typedef struct {
    unsigned char bLength;
    unsigned char bDescriptorType;
    char     bString[];
} USB_STRING_DESCRIPTOR, *PUSB_STRING_DESCRIPTOR;

typedef struct {
    unsigned char bLength;
    unsigned char bDescriptorType;
    char     bString[24];
} MANUFACTURER_DESCRIPTOR, *PMANUFACTURER_DESCRIPTOR;

typedef struct {
    unsigned char bLength;
    unsigned char bDescriptorType;
    char     bString[64]; // FIXME correct the length
} SERIAL_DESCRIPTOR, *PSERIAL_DESCRIPTOR;

typedef struct {
    unsigned char bLength;
    unsigned char bDescriptorType;
    char     bString[24]; // FIXME correct the length
} PRODUCT_DESCRIPTOR, *PPRODUCT_DESCRIPTOR;

typedef struct {
    unsigned char bLength;
    unsigned char bDescriptorType;
    unsigned short wLANGID0;
} LANGID_DESCRIPTOR, *PLANGID_DESCRIPTOR;
#pragma pack()


#define GET_STATUS  			0
#define CLEAR_FEATURE     		1
#define SET_FEATURE                 	3
#define SET_ADDRESS                 	5
#define GET_DESCRIPTOR              	6
#define SET_DESCRIPTOR              	7
#define GET_CONFIGURATION           	8
#define SET_CONFIGURATION           	9
#define GET_INTERFACE               	10
#define SET_INTERFACE               	11
#define SYNCH_FRAME                 	12

#define TYPE_DEVICE_DESCRIPTOR          1
#define TYPE_CONFIGURATION_DESCRIPTOR   2
#define TYPE_STRING_DESCRIPTOR          3
#define TYPE_INTERFACE_DESCRIPTOR       4
#define TYPE_ENDPOINT_DESCRIPTOR        5
#define TYPE_HID_DESCRIPTOR		0x21
#define TYPE_REPORT_DESCRIPTOR		0x22
#define TYPE_PHYSICAL_DESCRIPTOR        0x23

#endif /* #ifndef _CHAP9_H */
