#ifndef __HID_H
#define __HID_H

#include "pp_usb.h"

#ifndef __arm__
extern volatile uint8_t keyboard_send_report_timeout;
extern volatile uint8_t mouse_send_report_timeout;
#endif

extern const unsigned char KeyboardReportDescriptor[];
extern const unsigned char relMouseReportDescriptor[];
extern const unsigned char absMouseReportDescriptor[];

// these are the class specific Request for the HID class HID 1.11, 7.2
#define HID_REQ_GET_REPORT              0x01 /* mandatory */
#define HID_REQ_GET_IDLE                0x02
#define HID_REQ_GET_PROTOCOL            0x03
/* 0x04-0x08 reserved */
#define HID_REQ_SET_REPORT              0x09
#define HID_REQ_SET_IDLE                0x0A
#define HID_REQ_SET_PROTOCOL            0x0B

#define PROTO_REPORT 1 /* 7.2.5/6 */
#define PROTO_BOOT 0

void hid_init(void);
#ifndef __arm__
void hid_mouse_handle_classrequest(
				   u_int8_t bmRequestType,
				   u_int8_t bRequest,
				   u_int16_t wValue,
				   u_int16_t wIndex,
				   u_int16_t wLength
				   );
void hid_keyboard_handle_classrequest(
				      u_int8_t bmRequestType,
				      u_int8_t bRequest,
				      u_int16_t wValue,
				      u_int16_t wIndex,
				      u_int16_t wLength
				      );
void hid_keyboard_set_report(const uint8_t* data, const int length);
void hid_mouse_set_pointer(const uint8_t* data, const int length);
#endif
void keyboard_set_event(uint8_t modifier, uint8_t key, uint8_t down);
void hid_main_loop_callback(void);

#endif /* #ifdef __HID_H */
