#ifndef _LINUX_LARA_USB_H
#define _LINUX_LARA_USB_H

#include "kernel_usb.h"

#ifdef __KERNEL__

#include <linux/spinlock.h>
#include <linux/wait.h>
#include <asm/byteorder.h>

#include "pp_usb_ISP1181B.h"

#define noUSB_DEBUG
#ifdef USB_DEBUG
#define UD(fmt, args...)	{ printk(fmt, ##args); }
#else
#define UD(fmt, args...)
#endif

#define MAX_INTERFACES 16

#define LARA_USB_MAJOR			((u8)244)

#define my__wait_event_interruptible(wq, condition, ret)                  \
do {                                                                    \
        wait_queue_t __wait;                                            \
        init_waitqueue_entry(&__wait, current);                         \
                                                                        \
        add_wait_queue(&wq, &__wait);                                   \
        for (;;) {                                                      \
                set_current_state(TASK_INTERRUPTIBLE);                  \
                if (condition)                                          \
                        break;                                          \
                if (!signal_pending(current)) {                         \
		    if (0 != schedule_timeout(HZ/2))			\
                        continue;                                       \
                    else                                                \
			break;						\
                }                                                       \
                ret = -ERESTARTSYS;                                     \
                break;                                                  \
        }                                                               \
        current->state = TASK_RUNNING;                                  \
        remove_wait_queue(&wq, &__wait);                                \
} while (0)

#define my_wait_event_interruptible(wq, condition)                         \
({                                                                      \
        int __ret = 0;                                                  \
        if (!(condition))                                               \
                my__wait_event_interruptible(wq, condition, __ret);       \
        __ret;                                                          \
})



typedef struct {
    struct list_head listnode;
    usb_usrspace_data_t rpc;
} rpc_queue_entry_t;


typedef enum {
    IDLE,
    SETUPPROC,
    DATAOUT,
    DATAIN,
    STALL,
    REQUESTPROC,
    HANDSHAKE,
} control_state_t;


typedef enum {
    BULK_IN = 1,
    BULK_OUT = 2,
    INTERRUPT_IN = 3,
    INTERRUPT_OUT = 4
} ep_type_t;

typedef struct {
    uint32_t ioCount;
    uint32_t ioSize;
    uint32_t bufSize;
    uint8_t* pData;
    ep_type_t ep_type;
    uint8_t used;
    uint8_t reset;
    uint8_t waiting;
    uint8_t timedout;
    uint8_t status;
    uint32_t last_length;
    uint8_t last_packet[64];
    void (*isr_int_in_cb) (uint8_t ep);
    void (*main_bulk_out_cb) (uint8_t ep);
    void (*main_bulk_in_cb) (uint8_t ep);
    void (*unstall_cb) (uint8_t ep);
    uint8_t (*allow_unstall_cb) (uint8_t ep);
} ep_t;

typedef struct {
    char			name[15];
    int				isr_registered;
    int                         rmmod;
    spinlock_t			chip_access_lock;
    wait_queue_head_t		req_wq;
    volatile int                int_occured;
    struct task_struct *	usb_thread;
    struct semaphore *		usb_notify;
    int                         wakeup;
    wait_queue_head_t           int_wq;
    spinlock_t                 rpc_queue_lock;
    volatile unsigned int      rpc_queue_elem_cnt;
    struct list_head           rpc_queue;
} lara_usb_dev_t;

#define MAX_STRING_DESCRIPTORS 5

void WriteEndpoint(uint8_t ep, const uint8_t * buf, uint16_t len);
void endpoint_init(void);
void pp_usb_wakeup_file_process(void);
void pp_usb_wakeup_main_loop(void);
void call_user_space(usb_usrspace_data_t * rpc);

typedef struct {
    uint8_t* ConfigDescriptor;
    uint8_t* DeviceDescriptor;
    uint8_t* StringDescriptors[MAX_STRING_DESCRIPTORS];
    void (*config_endpoints) (void);
    void (*usb_init) (void);
    int (*send_data) (const uint8_t channel, const uint8_t type, const char* data, const int length);
    uint32_t ep_interrupts; /* ISP1181B_INT_IEPx| ISP1181B_INT_IEPy */
    void (*ep_int_functions[ISP1181B_MAX_EP])(uint8_t); /* int callback functions for ep 1 to 14 */
    ep_t eps[ISP1181B_MAX_EP];
    int (*get_data_length)(uint8_t bmRequestType, uint8_t bRequest,
			   uint16_t wValue, uint16_t wIndex, uint16_t wLength);
    void (*vendor_device_request)(uint8_t bmRequestType, uint8_t bRequest,
				  uint16_t wValue, uint16_t wIndex, uint16_t wLength);
    void (*class_interface_request[MAX_INTERFACES])(uint8_t bmRequestType, uint8_t bRequest,
				  uint16_t wValue, uint16_t wIndex, uint16_t wLength);
    void (*non_std_descriptors)(uint16_t wValue, uint16_t wIndex, uint16_t wLength);
    int usb_max_packet_size;
    file_request_t file_req[PP_FEAT_USB_MASS_STORAGE_NO];
    int initialized;
} usb_driver_t;

#define USB_ENDPOINT_DIRECTION_MASK 0x80
#define MAX_CONTROLDATA_OUT_SIZE 128

#define BULK_IDLE  0
#define BULK_EVENT 1

typedef struct {
    uint8_t bmRequestType;
    uint8_t bRequest;
    uint16_t wValue;
    uint16_t wIndex;
    uint16_t wLength;
} device_request_t;

typedef struct {
    uint16_t wLength;
    uint16_t wCount;
    char* pData;
    device_request_t DeviceRequest;
} ControlData_t;


#ifdef SUCCESS
#  undef  SUCCESS
#endif
#define SUCCESS 0

#define EVENT_IDLE 0
#define EVENT_QUEUED 1


#define MAX_STANDARD_REQUEST 0x0d

#endif

#endif /* _LINUX_LARA_USB_H */

