#ifndef __PPHID_H__
#define __PPHID_H__

#include <linux/types.h>

#include <linux/config.h>

#include <asm/uaccess.h>

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/slab.h>
#include <linux/smp_lock.h>
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/timer.h>
#include <linux/list.h>
#include <linux/interrupt.h>
#include <linux/uts.h>
#include <linux/version.h>

#include <asm/byteorder.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/system.h>
#include <asm/unaligned.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
# include <linux/device.h>
#endif

#include <linux/usb_ch9.h>
#include <linux/usb_gadget.h>

#include "kernel_usb.h"

typedef struct _pphid_t pphid_t;
struct FTC_zero_dev;

pphid_t *pphid_init(void);
void pphid_deinit(pphid_t *hid);

int pphid_mouse_handle_classrequest(struct FTC_zero_dev *ZeroDev, const struct usb_ctrlrequest *ctrl);
int pphid_keyboard_handle_classrequest(struct FTC_zero_dev *ZeroDev, const struct usb_ctrlrequest *ctrl);

void pphid_keyboard_set_report(pphid_t *hid, struct usb_ep *ep, const uint8_t *data, int length);
void pphid_mouse_set_pointer(pphid_t *hid, struct usb_ep *ep, const uint8_t *data, int length);
void pphid_set_mouse_report_length(pphid_t *hid, int i);
void pphid_set_mouse_type(pphid_t *hid, usb_device_mouse_type_t mouse_type);
void pphid_ep_cb(struct usb_ep * ep);

#define MAX_MOUSE_REPORT 6 /* descriptor dependend */
#define MAX_KBD_REPORT 8 /* descriptor dependend */
#define MAX_REPORT 8

typedef struct {
    uint8_t last_packet[MAX_REPORT];
    int last_len;
    int timedout;
    int waiting;
} hid_class_ep_data_t;

#endif /* __PPHID_H__ */
