#ifndef __ppstorage__
#define __ppstorage__


#include <linux/kernel.h>
#include <linux/types.h>

#include <linux/config.h>

#include <asm/uaccess.h>

#include <linux/module.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/slab.h>
#include <linux/smp_lock.h>
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/timer.h>
#include <linux/list.h>
#include <linux/interrupt.h>
#include <linux/uts.h>
#include <linux/version.h>

#include <asm/byteorder.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/system.h>
#include <asm/unaligned.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,0)
# include <linux/device.h>
#endif

#include <linux/usb_ch9.h>
#include <linux/usb_gadget.h>

#include <linux/bitops.h>
#include <linux/blkdev.h>
#include <linux/compiler.h>
#include <linux/completion.h>
#include <linux/dcache.h>
#include <linux/fcntl.h>
#include <linux/file.h>
#include <linux/fs.h>
#include <linux/limits.h>
#include <linux/pagemap.h>
#include <linux/rwsem.h>
#include <linux/signal.h>
#include <linux/spinlock.h>
#include <linux/string.h>
#include <linux/uts.h>
#include <linux/wait.h>

#include "../lara_common.h"

/* USB Mass Storage Class - Specification Overview: Revision 1.2, June 32, 2003 */

/* USB protocol value = the transport method */
#define USB_PR_CBI	0x00		// Control/Bulk/Interrupt
#define USB_PR_CB	0x01		// Control/Bulk w/o interrupt
#define USB_PR_BULK	0x50		// Bulk-only

/* USB subclass value = the protocol encapsulation */
#define USB_SC_RBC	0x01		// Reduced Block Commands (flash)
#define USB_SC_8020	0x02		// SFF-8020i, MMC-2, ATAPI (CD-ROM)
#define USB_SC_QIC	0x03		// QIC-157 (tape)
#define USB_SC_UFI	0x04		// UFI (floppy)
#define USB_SC_8070	0x05		// SFF-8070i (removable)
#define USB_SC_SCSI	0x06		// Transparent SCSI

/* Number of buffers we will use.  2 is enough for double-buffering */
#define NUM_BUFFERS		2
#define MAX_COMMAND_SIZE	16	// Length of a SCSI Command Data Block

enum data_direction {
	DATA_DIR_UNKNOWN = 0,
	DATA_DIR_FROM_HOST,
	DATA_DIR_TO_HOST,
	DATA_DIR_NONE
};

#include "FTC_zero.h"

/* Command Block Wrapper */
struct bulk_cb_wrap {
	u32	Signature;		// Contains 'USBC'
	u32	Tag;			// Unique per command id
	u32	DataTransferLength;	// Size of the data
	u8	Flags;			// Direction in bit 7
	u8	Lun;			// LUN (normally 0)
	u8	Length;			// Of the CDB, <= MAX_COMMAND_SIZE
	u8	CDB[16];		// Command Data Block
};
#define USB_BULK_CB_WRAP_LEN	31
#define USB_BULK_CB_SIG		0x43425355	// Spells out USBC
#define USB_BULK_IN_FLAG	0x80

/* Command Status Wrapper */
struct bulk_cs_wrap {
	u32	Signature;		// Should = 'USBS'
	u32	Tag;			// Same as original command
	u32	Residue;		// Amount not transferred
	u8	Status;			// See below
};
#define USB_BULK_CS_WRAP_LEN	13
#define USB_BULK_CS_SIG		0x53425355	// Spells out 'USBS'
#define USB_STATUS_PASS		0
#define USB_STATUS_FAIL		1
#define USB_STATUS_PHASE_ERROR	2

typedef struct _bot_t {
    struct scsi_s *scsi;
    int index;
    char* BOTXfer_pData;
    // This doesn't really belong here, but it's the only way to get
    // this pointer into SCSI_Read/SCSI_Write:
    struct FTC_zero_dev *zero_dev;
} bot_t;

typedef enum {
    /* ordered by priority */
    PPSTORAGE_STATE_RUNNING,
    PPSTORAGE_STATE_RESET,
    PPSTORAGE_STATE_EXIT
} ppstorage_state_t;

struct ppstorage_intf_t {
	struct FTC_zero_dev	*zero_dev;
	int			dev_no; // Index into zero_dev->storage[]
	int			interface_number;
	bot_t			bot;
	int			protocol; // only SCSI for now, maybe UFI later on

	/* Thread management */
	struct task_struct	*thread_task;
	volatile int		thread_suspend;
	volatile ppstorage_state_t thread_state;
	spinlock_t		thread_lock;
	struct completion	thread_notifier_start;
	struct completion	thread_notifier_exit;
	struct completion	thread_notifier_reset;
	struct completion	thread_notifier_suspend;
	wait_queue_head_t	thread_wqh;
	volatile int		thread_wakeup;
	volatile int		response_pending;

	/* BOT ring buffer */
	struct zero_buffhd	*next_buffhd_to_fill;
	struct zero_buffhd	*next_buffhd_to_drain;
	struct zero_buffhd	buffhds[NUM_BUFFERS];

	/* Bulk endpoints */
	unsigned int		bulk_in_enabled;
	unsigned int		bulk_out_enabled;
	struct usb_ep		*Bin_ep;
	struct usb_ep		*Bout_ep;

	/* CBW contents (in CPU byte order): */
	int			cmnd_size;
	u8			cmnd[MAX_COMMAND_SIZE];
	enum data_direction	data_dir;
	u32			data_size;
	u32			tag;
	unsigned int		lun;

	/* BOT status fields for CSW */
	enum data_direction	data_dir_from_scsi;
	u32			data_size_from_scsi;
	u32			residue;
	u32			usb_amount_left;
	unsigned int		phase_error;
	unsigned int		error;
	unsigned int		short_packet_received;

	// Former struct lun:
	struct file	*filp;
	loff_t		file_length;
};

int ppstorage_handle_class_req(struct FTC_zero_dev *ZeroDev, const struct usb_ctrlrequest *ctrl);

void ppstorage_close_file(struct ppstorage_intf_t *intf);
void ppstorage_set_file(struct FTC_zero_dev *fsg, int dev_no, char* filename, int readonly, usb_device_type_t type, uint32_t blocklen);
int ppstorage_sync_file(struct ppstorage_intf_t *intf);
int ppstorage_bind(struct usb_gadget *gadget);
int ppstorage_unbind(struct usb_gadget *gadget);
int ppstorage_suspend_thread(struct ppstorage_intf_t *intf, int suspend);

struct ppstorage_intf_t *ppstorage_intf_new(struct FTC_zero_dev *zero_dev, int index);
void ppstorage_intf_free(struct ppstorage_intf_t *intf);

#endif /* __ppstorage__ */
