#ifndef __RIPCBELKIN_USB_H__
#define __RIPCBELKIN_USB_H__

#include "pp_usb.h"
#include "chap9.h"


int ripcbelkin_usb_init(usb_driver_t *ud, usb_device_mouse_type_t mouse_type, int * enable_mass_storage);

#pragma pack(1)
typedef struct {
    USB_CONFIGURATION_DESCRIPTOR ConfigDescriptor;
    USB_INTERFACE_DESCRIPTOR Mouse_InterfaceDescriptor;
    USB_ENDPOINT_DESCRIPTOR Mouse_EndpointDescriptor_0;
    USB_ENDPOINT_DESCRIPTOR Keyboard_EndpointDescriptor_0;
} RIPCBELKIN_USB_CONFIG_DATA, *PRIPCBELKIN_USB_CONFIG_DATA;

#define BELKIN_RIPC_MOUSE_EP_0    EP1
#define BELKIN_RIPC_KEYBOARD_EP_0 EP2
#define BELKIN_RIPC_MOUSE_EP_1    EP3
#define BELKIN_RIPC_KEYBOARD_EP_1 EP4

/* VRC - Vendor Request Codes */
#define VRC_CONSOLE_HOST_CHANGE   0x01
#define VRC_CONSOLE_DEVICE_STATUS 0x02
#define VRC_CONSOLE_BEEP          0x03
#define VRC_CONSOLE_AUTOSCAN      0x04
#define VRC_IP_ADDRESS            0x05
#define VRC_CONSOLE_LED_STATUS    0x06
#define VRC_OSD_ON                0x07
#define VRC_OSD_OFF               0x08
#define VRC_UNIT_ADDED            0x09
#define VRC_UNIT_REMOVED          0x0A
#define VRC_GATEWAY_ADDRESS       0x0B

typedef struct {
    uint8_t old_bank;
    uint8_t old_host;
    uint8_t new_bank;
    uint8_t new_host;
    uint8_t control;
} host_change_t;

typedef struct {
    uint8_t gw0;
    uint8_t gw1;
    uint8_t gw2;
    uint8_t gw3;
    uint8_t reserved0;
    uint8_t reserved1;
    uint8_t reserved2;
    uint8_t reserved3;
} gateway_t;   

typedef struct {
    uint8_t ip0;
    uint8_t ip1;
    uint8_t ip2;
    uint8_t ip3;
    uint8_t mask0;
    uint8_t mask1;
    uint8_t mask2;
    uint8_t mask3;
} ip_and_mask_t;

typedef struct {
    uint16_t x;
    uint16_t y;
    uint16_t h;
    uint16_t w;
} osd_info_t;
	
#pragma pack()

#endif /* ! __RIPCBELKIN_USB_H__ */
   
