#ifndef __SENSE_CODES_H
#define __SENSE_CODES_H


#define ASC(x) ((x >> 8) & 0xff)
#define ASCQ(x) (x & 0xff)
/*
File: http://www.t10.org/lists/asc-alph.txt

SCSI ASC/ASCQ Assignments
Alphabetic Sorted Listing
as of  9/05/05

										      D - DIRECT ACCESS DEVICE (SBC-2)                   device column key
										      .T - SEQUENTIAL ACCESS DEVICE (SSC)               -------------------
										      . L - PRINTER DEVICE (SSC)                           blank = reserved
										      .  P - PROCESSOR DEVICE (SPC)                     not blank = allowed
										      .  .W - WRITE ONCE READ MULTIPLE DEVICE (SBC-2)
										      .  . R - CD DEVICE (MMC)
										      .  .  O - OPTICAL MEMORY DEVICE (SBC-2)
										      .  .  .M - MEDIA CHANGER DEVICE (SMC)
										      .  .  . A - STORAGE ARRAY DEVICE (SCC)
										      .  .  .  E - ENCLOSURE SERVICES DEVICE (SES)
										      .  .  .  .B - SIMPLIFIED DIRECT-ACCESS DEVICE (RBC)
										      .  .  .  . K - OPTICAL CARD READER/WRITER DEVICE (OCRW)
										      .  .  .  .  V - AUTOMATION/DRIVE INTERFACE (ADC)
										      .  .  .  .  .F - OBJECT-BASED STORAGE (OSD)
                                                                          ASC/ASCQ    DTLPWROMAEBKVF
-----------------------------------------------------------------------   --------    --------------     */
#define ACCESS_DENIED___ACL_LUN_CONFLICT				   0x200B  // DT PWROMAEBK    
#define ACCESS_DENIED___ENROLLMENT_CONFLICT				   0x2008  // DT PWROMAEBK    
#define ACCESS_DENIED___INITIATOR_PENDING_ENROLLED			   0x2001  // DT PWROMAEBK    
#define ACCESS_DENIED___INVALID_LU_IDENTIFIER				   0x2009  // DT PWROMAEBK    
#define ACCESS_DENIED___INVALID_MGMT_ID_KEY				   0x2003  // DT PWROMAEBK    
#define ACCESS_DENIED___INVALID_PROXY_TOKEN				   0x200A  // DT PWROMAEBK    
#define ACCESS_DENIED___NO_ACCESS_RIGHTS				   0x2002  // DT PWROMAEBK    
#define ACK_NAK_TIMEOUT							   0x4B03  // DT PWROMAEBK    
#define ADD_LOGICAL_UNIT_FAILED						   0x6702  //         A       
#define ADDRESS_MARK_NOT_FOUND_FOR_DATA_FIELD				   0x1300  // D   W O   BK    
#define ADDRESS_MARK_NOT_FOUND_FOR_ID_FIELD				   0x1200  // D   W O   BK    
#define ASSIGN_FAILURE_OCCURRED						   0x6708  //         A       
#define ASSOCIATED_WRITE_PROTECT					   0x2703  //  T   R          
#define ASYMMETRIC_ACCESS_STATE_CHANGED					   0x2A06  // DTLPWROMAEBKVF  
#define ASYNCHRONOUS_INFORMATION_PROTECTION_ERROR_DETECTED		   0x4704  // DTLPWROMAEBKVF  
#define ATA_DEVICE_FAILED_SET_FEATURES					   0x4471  // DT        B     
#define ATA_PASS_THROUGH_INFORMATION_AVAILABLE				   0x001D  // DT        B     
#define ATTACHMENT_OF_LOGICAL_UNIT_FAILED				   0x6706  //         A       
#define AUDIO_PLAY_OPERATION_IN_PROGRESS				   0x0011  //      R          
#define AUDIO_PLAY_OPERATION_PAUSED					   0x0012  //      R          
#define AUDIO_PLAY_OPERATION_STOPPED_DUE_TO_ERROR			   0x0014  //      R          
#define AUDIO_PLAY_OPERATION_SUCCESSFULLY_COMPLETED			   0x0013  //      R          
#define AUTOMATIC_DOCUMENT_FEEDER_COVER_UP				   0x6600  //                 
#define AUTOMATIC_DOCUMENT_FEEDER_LIFT_UP				   0x6601  //                 
#define AUXILIARY_MEMORY_OUT_OF_SPACE					   0x5506  // DT  WROM  B     
#define AUXILIARY_MEMORY_READ_ERROR					   0x1112  // DT  WROM  B     
#define AUXILIARY_MEMORY_WRITE_ERROR					   0x0C0B  // DT  WROM  B     
#define BEGINNING_OF_PARTITION_MEDIUM_DETECTED				   0x0004  //  T              
#define BLOCK_NOT_COMPRESSIBLE						   0x0C06  // DT  W O   B     
#define BLOCK_SEQUENCE_ERROR						   0x1404  //  T              
#define BUS_DEVICE_RESET_FUNCTION_OCCURRED				   0x2903  // DTLPWROMAEBKVF  
#define CANNOT_DECOMPRESS_USING_DECLARED_ALGORITHM			   0x110E  // DT  WRO   B     
#define CANNOT_FORMAT_MEDIUM___INCOMPATIBLE_MEDIUM			   0x3006  // DT  WRO   B     
#define CANNOT_READ_MEDIUM___INCOMPATIBLE_FORMAT			   0x3002  // DT  WRO   BK    
#define CANNOT_READ_MEDIUM___UNKNOWN_FORMAT				   0x3001  // DT  WRO   BK    
#define CANNOT_WRITE___APPLICATION_CODE_MISMATCH			   0x3008  //      R          
#define CANNOT_WRITE_MEDIUM___INCOMPATIBLE_FORMAT			   0x3005  // DT  WRO   BK    
#define CANNOT_WRITE_MEDIUM___UNKNOWN_FORMAT				   0x3004  // DT  WRO   BK    
#define CAPACITY_DATA_HAS_CHANGED					   0x2A09  // D               
#define CARTRIDGE_FAULT							   0x5200  //  T              
#define CD_CONTROL_ERROR						   0x7300  //      R          
#define CDB_DECRYPTION_ERROR						   0x2401  // DTLPWROMAEBKVF  
#define CHANGED_OPERATING_DEFINITION					   0x3F02  // DTLPWROM  BK    
#define CIRC_UNRECOVERED_ERROR						   0x1106  //     WRO   B     
#define CLEANING_CARTRIDGE_INSTALLED					   0x3003  // DT   R     K    
#define CLEANING_FAILURE						   0x3007  // DTL WROMAEBKVF  
#define CLEANING_REQUEST_REJECTED					   0x300A  // DT  WROMAEBK    
#define CLEANING_REQUESTED						   0x0017  // DTL WROMAEBKVF  
#define COMMAND_PHASE_ERROR						   0x4A00  // DTLPWROMAEBKVF  
#define COMMAND_SEQUENCE_ERROR						   0x2C00  // DTLPWROMAEBKVF  
#define COMMAND_TO_LOGICAL_UNIT_FAILED					   0x6E00  //         A       
#define COMMANDS_CLEARED_BY_ANOTHER_INITIATOR				   0x2F00  // DTLPWROMAEBKVF  
#define COMPONENT_DEVICE_ATTACHED					   0x3F04  // DT  WROMAEBK    
#define COMPRESSION_CHECK_MISCOMPARE_ERROR				   0x0C04  // DT  W O   B     
#define CONDITIONAL_WRITE_PROTECT					   0x2706  //      R          
#define CONFIGURATION_FAILURE						   0x6700  //         A       
#define CONFIGURATION_OF_INCAPABLE_LOGICAL_UNITS_FAILED			   0x6701  //         A       
#define CONTROLLER_IMPENDING_FAILURE_ACCESS_TIMES_TOO_HIGH		   0x5D25  // D         B     
#define CONTROLLER_IMPENDING_FAILURE_CHANNEL_PARAMETRICS		   0x5D27  // D         B     
#define CONTROLLER_IMPENDING_FAILURE_CONTROLLER_DETECTED		   0x5D28  // D         B     
#define CONTROLLER_IMPENDING_FAILURE_DATA_ERROR_RATE_TOO_HIGH		   0x5D22  // D         B     
#define CONTROLLER_IMPENDING_FAILURE_DRIVE_CALIBRATION_RETRY_COUNT	   0x5D2C  // D         B     
#define CONTROLLER_IMPENDING_FAILURE_DRIVE_ERROR_RATE_TOO_HIGH		   0x5D21  // D         B     
#define CONTROLLER_IMPENDING_FAILURE_GENERAL_HARD_DRIVE_FAILURE		   0x5D20  // D         B     
#define CONTROLLER_IMPENDING_FAILURE_SEEK_ERROR_RATE_TOO_HIGH		   0x5D23  // D         B     
#define CONTROLLER_IMPENDING_FAILURE_SEEK_TIME_PERFORMANCE		   0x5D2A  // D         B     
#define CONTROLLER_IMPENDING_FAILURE_SPIN_UP_RETRY_COUNT		   0x5D2B  // D         B     
#define CONTROLLER_IMPENDING_FAILURE_START_UNIT_TIMES_TOO_HIGH		   0x5D26  // D         B     
#define CONTROLLER_IMPENDING_FAILURE_THROUGHPUT_PERFORMANCE		   0x5D29  // D         B     
#define CONTROLLER_IMPENDING_FAILURE_TOO_MANY_BLOCK_REASSIGNS		   0x5D24  // D         B     
#define COPY_CANNOT_EXECUTE_SINCE_HOST_CANNOT_DISCONNECT		   0x2B00  // DTLPWRO    K    
#define COPY_PROTECTION_KEY_EXCHANGE_FAILURE___AUTHENTICATION_FAILURE	   0x6F00  //      R          
#define COPY_PROTECTION_KEY_EXCHANGE_FAILURE___KEY_NOT_ESTABLISHED	   0x6F02  //      R          
#define COPY_PROTECTION_KEY_EXCHANGE_FAILURE___KEY_NOT_PRESENT		   0x6F01  //      R          
#define COPY_SEGMENT_GRANULARITY_VIOLATION				   0x260D  // DTLPWRO    K    
#define COPY_TARGET_DEVICE_DATA_OVERRUN					   0x0D05  // DTLPWRO A  K    
#define COPY_TARGET_DEVICE_DATA_UNDERRUN				   0x0D04  // DTLPWRO A  K    
#define COPY_TARGET_DEVICE_NOT_REACHABLE				   0x0D02  // DTLPWRO A  K    
#define CREATION_OF_LOGICAL_UNIT_FAILED					   0x6707  //         A       
#define CURRENT_PROGRAM_AREA_IS_EMPTY					   0x2C04  //      R          
#define CURRENT_PROGRAM_AREA_IS_NOT_EMPTY				   0x2C03  //      R          
#define CURRENT_SESSION_NOT_FIXATED_FOR_APPEND				   0x3009  //      R          
#define DATA_BLOCK_APPLICATION_TAG_CHECK_FAILED				   0x1002  // DT  W O         
#define DATA_BLOCK_GUARD_CHECK_FAILED					   0x1001  // DT  W O         
#define DATA_BLOCK_REFERENCE_TAG_CHECK_FAILED				   0x1003  // DT  W O         
#define DATA_CHANNEL_IMPENDING_FAILURE_ACCESS_TIMES_TOO_HIGH		   0x5D35  // D         B     
#define DATA_CHANNEL_IMPENDING_FAILURE_CHANNEL_PARAMETRICS		   0x5D37  // D         B     
#define DATA_CHANNEL_IMPENDING_FAILURE_CONTROLLER_DETECTED		   0x5D38  // D         B     
#define DATA_CHANNEL_IMPENDING_FAILURE_DATA_ERROR_RATE_TOO_HIGH		   0x5D32  // D         B     
#define DATA_CHANNEL_IMPENDING_FAILURE_DRIVE_CALIBRATION_RETRY_COUNT	   0x5D3C  // D         B     
#define DATA_CHANNEL_IMPENDING_FAILURE_DRIVE_ERROR_RATE_TOO_HIGH	   0x5D31  // D         B     
#define DATA_CHANNEL_IMPENDING_FAILURE_GENERAL_HARD_DRIVE_FAILURE	   0x5D30  // D         B     
#define DATA_CHANNEL_IMPENDING_FAILURE_SEEK_ERROR_RATE_TOO_HIGH		   0x5D33  // D         B     
#define DATA_CHANNEL_IMPENDING_FAILURE_SEEK_TIME_PERFORMANCE		   0x5D3A  // D         B     
#define DATA_CHANNEL_IMPENDING_FAILURE_SPIN_UP_RETRY_COUNT		   0x5D3B  // D         B     
#define DATA_CHANNEL_IMPENDING_FAILURE_START_UNIT_TIMES_TOO_HIGH	   0x5D36  // D         B     
#define DATA_CHANNEL_IMPENDING_FAILURE_THROUGHPUT_PERFORMANCE		   0x5D39  // D         B     
#define DATA_CHANNEL_IMPENDING_FAILURE_TOO_MANY_BLOCK_REASSIGNS		   0x5D34  // D         B     
#define DATA_DECRYPTION_ERROR						   0x2605  // DTLPWROMA BK    
#define DATA_EXPANSION_OCCURRED_DURING_COMPRESSION			   0x0C05  // DT  W O   B     
#define DATA_LOSS_ON_LOGICAL_UNIT					   0x6900  //         A       
#define DATA_OFFSET_ERROR						   0x4B05  // DT PWROMAEBK    
#define DATA_PATH_FAILURE__SHOULD_USE_40_NN_				   0x4100  // D               
#define DATA_PHASE_CRC_ERROR_DETECTED					   0x4701  // DTLPWROMAEBKVF  
#define DATA_PHASE_ERROR						   0x4B00  // DTLPWROMAEBKVF  
#define DATA_RE_SYNCHRONIZATION_ERROR					   0x1107  //     W O   B     
#define DATA_SYNC_ERROR___DATA_AUTO_REALLOCATED				   0x1603  // D   W O   BK    
#define DATA_SYNC_ERROR___DATA_REWRITTEN				   0x1601  // D   W O   BK    
#define DATA_SYNC_ERROR___RECOMMEND_REASSIGNMENT			   0x1604  // D   W O   BK    
#define DATA_SYNC_ERROR___RECOMMEND_REWRITE				   0x1602  // D   W O   BK    
#define DATA_SYNCHRONIZATION_MARK_ERROR					   0x1600  // D   W O   BK    
#define DE_COMPRESSION_CRC_ERROR					   0x110D  // DT  WRO   B     
#define DECOMPRESSION_EXCEPTION_LONG_ALGORITHM_ID			   0x7100  //  T              
#define DECOMPRESSION_EXCEPTION_SHORT_ALGORITHM_ID_OF_NN		   0x70NN  //  T              
#define DEFECT_LIST_ERROR						   0x1900  // D     O    K    
#define DEFECT_LIST_ERROR_IN_GROWN_LIST					   0x1903  // D     O    K    
#define DEFECT_LIST_ERROR_IN_PRIMARY_LIST				   0x1902  // D     O    K    
#define DEFECT_LIST_NOT_AVAILABLE					   0x1901  // D     O    K    
#define DEFECT_LIST_NOT_FOUND						   0x1C00  // D     O   BK    
#define DEFECT_LIST_UPDATE_FAILURE					   0x3201  // D   W O   BK    
#define DEVICE_IDENTIFIER_CHANGED					   0x3F05  // DT  WROMAEBK    
#define DEVICE_INTERNAL_RESET						   0x2904  // DTLPWROMAEBKVF  
#define DIAGNOSTIC_FAILURE_ON_COMPONENT_NN__80H_FFH_			   0x40NN  // DTLPWROMAEBKVF  
#define DOCUMENT_JAM_IN_AUTOMATIC_DOCUMENT_FEEDER			   0x6602  //                 
#define DOCUMENT_MISS_FEED_AUTOMATIC_IN_DOCUMENT_FEEDER			   0x6603  //                 
#define DRIVE_REGION_MUST_BE_PERMANENT_REGION_RESET_COUNT_ERROR		   0x6F05  //      R          
#define ECHO_BUFFER_OVERWRITTEN						   0x3F0F  // DTLPWROMAEBKVF  
#define EMPTY_OR_PARTIALLY_WRITTEN_RESERVED_TRACK			   0x7204  //      R          
#define ENCLOSURE_FAILURE						   0x3400  // DTLPWROMAEBKVF  
#define ENCLOSURE_SERVICES_CHECKSUM_ERROR				   0x3505  // DTL WROMAEBKVF  
#define ENCLOSURE_SERVICES_FAILURE					   0x3500  // DTLPWROMAEBKVF  
#define ENCLOSURE_SERVICES_TRANSFER_FAILURE				   0x3503  // DTLPWROMAEBKVF  
#define ENCLOSURE_SERVICES_TRANSFER_REFUSED				   0x3504  // DTLPWROMAEBKVF  
#define ENCLOSURE_SERVICES_UNAVAILABLE					   0x3502  // DTLPWROMAEBKVF  
#define END_OF_MEDIUM_REACHED						   0x3B0F  //      R          
#define END_OF_USER_AREA_ENCOUNTERED_ON_THIS_TRACK			   0x6300  //      R          
#define END_OF_DATA_DETECTED						   0x0005  //  TL             
#define END_OF_DATA_NOT_FOUND						   0x1403  //  T              
#define END_OF_PARTITION_MEDIUM_DETECTED				   0x0002  //  T              
#define ERASE_FAILURE							   0x5100  //  T   RO         
#define ERASE_FAILURE___INCOMPLETE_ERASE_OPERATION_DETECTED		   0x5101  //      R          
#define ERASE_OPERATION_IN_PROGRESS					   0x0018  //  T              
#define ERROR_DETECTED_BY_THIRD_PARTY_TEMPORARY_INITIATOR		   0x0D00  // DTLPWRO A  K    
#define ERROR_LOG_OVERFLOW						   0x0A00  // DTLPWROMAEBKVF  
#define ERROR_READING_ISRC_NUMBER					   0x1110  //      R          
#define ERROR_READING_UPC_EAN_NUMBER					   0x110F  //      R          
#define ERROR_TOO_LONG_TO_CORRECT					   0x1102  // DT  WRO   BK    
#define ESN___DEVICE_BUSY_CLASS_EVENT					   0x3806  //           B     
#define ESN___MEDIA_CLASS_EVENT						   0x3804  //           B     
#define ESN___POWER_MANAGEMENT_CLASS_EVENT				   0x3802  //           B     
#define EVENT_STATUS_NOTIFICATION					   0x3800  //           B     
#define EXCESSIVE_WRITE_ERRORS						   0x0302  //  T              
#define EXCHANGE_OF_LOGICAL_UNIT_FAILED					   0x6704  //         A       
#define FAILED_TO_SENSE_BOTTOM_OF_FORM					   0x3B07  //   L             
#define FAILED_TO_SENSE_TOP_OF_FORM					   0x3B06  //   L             
#define FAILURE_PREDICTION_THRESHOLD_EXCEEDED				   0x5D00  // DTLPWROMAEBKVF  
#define FAILURE_PREDICTION_THRESHOLD_EXCEEDED__FALSE_			   0x5DFF  // DTLPWROMAEBKVF  
#define FILEMARK_DETECTED						   0x0001  //  T              
#define FILEMARK_OR_SETMARK_NOT_FOUND					   0x1402  //  T              
#define FIRMWARE_IMPENDING_FAILURE_ACCESS_TIMES_TOO_HIGH		   0x5D65  // D         B     
#define FIRMWARE_IMPENDING_FAILURE_CHANNEL_PARAMETRICS			   0x5D67  // D         B     
#define FIRMWARE_IMPENDING_FAILURE_CONTROLLER_DETECTED			   0x5D68  // D         B     
#define FIRMWARE_IMPENDING_FAILURE_DATA_ERROR_RATE_TOO_HIGH		   0x5D62  // D         B     
#define FIRMWARE_IMPENDING_FAILURE_DRIVE_CALIBRATION_RETRY_COUNT	   0x5D6C  // D         B     
#define FIRMWARE_IMPENDING_FAILURE_DRIVE_ERROR_RATE_TOO_HIGH		   0x5D61  // D         B     
#define FIRMWARE_IMPENDING_FAILURE_GENERAL_HARD_DRIVE_FAILURE		   0x5D60  // D         B     
#define FIRMWARE_IMPENDING_FAILURE_SEEK_ERROR_RATE_TOO_HIGH		   0x5D63  // D         B     
#define FIRMWARE_IMPENDING_FAILURE_SEEK_TIME_PERFORMANCE		   0x5D6A  // D         B     
#define FIRMWARE_IMPENDING_FAILURE_SPIN_UP_RETRY_COUNT			   0x5D6B  // D         B     
#define FIRMWARE_IMPENDING_FAILURE_START_UNIT_TIMES_TOO_HIGH		   0x5D66  // D         B     
#define FIRMWARE_IMPENDING_FAILURE_THROUGHPUT_PERFORMANCE		   0x5D69  // D         B     
#define FIRMWARE_IMPENDING_FAILURE_TOO_MANY_BLOCK_REASSIGNS		   0x5D64  // D         B     
#define FOCUS_SERVO_FAILURE						   0x0902  //     WRO    K    
#define FORMAT_COMMAND_FAILED						   0x3101  // D L  RO   B     
#define GENERATION_DOES_NOT_EXIST					   0x5800  //       O         
#define GROWN_DEFECT_LIST_NOT_FOUND					   0x1C02  // D     O   BK    
#define HARDWARE_IMPENDING_FAILURE_ACCESS_TIMES_TOO_HIGH		   0x5D15  // D         B     
#define HARDWARE_IMPENDING_FAILURE_CHANNEL_PARAMETRICS			   0x5D17  // D         B     
#define HARDWARE_IMPENDING_FAILURE_CONTROLLER_DETECTED			   0x5D18  // D         B     
#define HARDWARE_IMPENDING_FAILURE_DATA_ERROR_RATE_TOO_HIGH		   0x5D12  // D         B     
#define HARDWARE_IMPENDING_FAILURE_DRIVE_CALIBRATION_RETRY_COUNT	   0x5D1C  // D         B     
#define HARDWARE_IMPENDING_FAILURE_DRIVE_ERROR_RATE_TOO_HIGH		   0x5D11  // D         B     
#define HARDWARE_IMPENDING_FAILURE_GENERAL_HARD_DRIVE_FAILURE		   0x5D10  // D         B     
#define HARDWARE_IMPENDING_FAILURE_SEEK_ERROR_RATE_TOO_HIGH		   0x5D13  // D         B     
#define HARDWARE_IMPENDING_FAILURE_SEEK_TIME_PERFORMANCE		   0x5D1A  // D         B     
#define HARDWARE_IMPENDING_FAILURE_SPIN_UP_RETRY_COUNT			   0x5D1B  // D         B     
#define HARDWARE_IMPENDING_FAILURE_START_UNIT_TIMES_TOO_HIGH		   0x5D16  // D         B     
#define HARDWARE_IMPENDING_FAILURE_THROUGHPUT_PERFORMANCE		   0x5D19  // D         B     
#define HARDWARE_IMPENDING_FAILURE_TOO_MANY_BLOCK_REASSIGNS		   0x5D14  // D         B     
#define HARDWARE_WRITE_PROTECTED					   0x2701  // DT  WRO   BK    
#define HEAD_SELECT_FAULT						   0x0904  // DT  WRO   B     
#define I_O_PROCESS_TERMINATED						   0x0006  // DTLPWROMAEBKVF  
#define ID_CRC_OR_ECC_ERROR						   0x1000  // D   W O   BK    
#define IDLE_CONDITION_ACTIVATED_BY_COMMAND				   0x5E03  // DTLPWRO A  K    
#define IDLE_CONDITION_ACTIVATED_BY_TIMER				   0x5E01  // DTLPWRO A  K    
#define ILLEGAL_COMMAND_WHILE_IN_EXPLICIT_ADDRESS_MODE			   0x2006  //  T              
#define ILLEGAL_COMMAND_WHILE_IN_IMPLICIT_ADDRESS_MODE			   0x2007  //  T              
#define ILLEGAL_COMMAND_WHILE_IN_WRITE_CAPABLE_STATE			   0x2004  //  T              
#define ILLEGAL_FUNCTION__USE_20_00__24_00__OR_26_00_			   0x2200  // D               
#define ILLEGAL_MODE_FOR_THIS_TRACK					   0x6400  //      R          
#define ILLEGAL_POWER_CONDITION_REQUEST					   0x2C05  //           B     
#define IMPLICIT_ASYMMETRIC_ACCESS_STATE_TRANSITION_FAILED		   0x2A07  // DTLPWROMAEBKVF  
#define IMPORT_OR_EXPORT_ELEMENT_ACCESSED				   0x2801  // DT  WROM  B     
#define INCOMPATIBLE_MEDIUM_INSTALLED					   0x3000  // DT  WROM  BK    
#define INCOMPLETE_BLOCK_READ						   0x1108  //  T              
#define INCORRECT_COPY_TARGET_DEVICE_TYPE				   0x0D03  // DTLPWRO A  K    
#define INFORMATION_UNIT_TOO_LONG					   0x0E02  // DT PWROMAEBK F  
#define INFORMATION_UNIT_TOO_SHORT					   0x0E01  // DT PWROMAEBK F  
#define INFORMATION_UNIT_iuCRC_ERROR_DETECTED				   0x4703  // DTLPWROMAEBKVF  
#define INFORMATIONAL__REFER_TO_LOG					   0x6A00  //         A       
#define INITIATOR_DETECTED_ERROR_MESSAGE_RECEIVED			   0x4800  // DTLPWROMAEBKVF  
#define INITIATOR_RESPONSE_TIMEOUT					   0x4B06  // DT PWROMAEBK    
#define INLINE_DATA_LENGTH_EXCEEDED					   0x260B  // DTLPWRO    K    
#define INQUIRY_DATA_HAS_CHANGED					   0x3F03  // DTLPWROMAEBKVF  
#define INSUFFICIENT_ACCESS_CONTROL_RESOURCES				   0x5505  // DT PWROMAEBK    
#define INSUFFICIENT_REGISTRATION_RESOURCES				   0x5504  // DTLPWROMAE K    
#define INSUFFICIENT_RESERVATION_RESOURCES				   0x5502  // DTLPWROMAE K    
#define INSUFFICIENT_RESOURCES						   0x5503  // DTLPWROMAE K    
#define INSUFFICIENT_TIME_FOR_OPERATION					   0x2E00  //      R          
#define INTERNAL_TARGET_FAILURE						   0x4400  // DTLPWROMAEBKVF  
#define INVALID_ADDRESS_FOR_WRITE					   0x2102  //      R          
#define INVALID_BITS_IN_IDENTIFY_MESSAGE				   0x3D00  // DTLPWROMAE K    
#define INVALID_COMBINATION_OF_WINDOWS_SPECIFIED			   0x2C02  //                 
#define INVALID_COMMAND_OPERATION_CODE					   0x2000  // DTLPWROMAEBKVF  
#define INVALID_DATA_OUT_BUFFER_INTEGRITY_CHECK_VALUE			   0x260F  //              F  
#define INVALID_ELEMENT_ADDRESS						   0x2101  // DT  WROM  BK    
#define INVALID_FIELD_IN_CDB						   0x2400  // DTLPWROMAEBKVF  
#define INVALID_FIELD_IN_COMMAND_INFORMATION_UNIT			   0x0E03  // DT P R MAEBK F  
#define INVALID_FIELD_IN_PARAMETER_LIST					   0x2600  // DTLPWROMAEBKVF  
#define INVALID_INFORMATION_UNIT					   0x0E00  // DT PWROMAEBK F  
#define INVALID_MESSAGE_ERROR						   0x4900  // DTLPWROMAEBKVF  
#define INVALID_OPERATION_FOR_COPY_SOURCE_OR_DESTINATION		   0x260C  // DTLPWRO    K    
#define INVALID_PACKET_SIZE						   0x6401  //      R          
#define INVALID_PARAMETER_WHILE_PORT_IS_ENABLED				   0x260E  // DT PWROMAEBK    
#define INVALID_RELEASE_OF_PERSISTENT_RESERVATION			   0x2604  // DTLPWROMAEBKVF  
#define INVALID_TARGET_PORT_TRANSFER_TAG_RECEIVED			   0x4B01  // DT PWROMAEBK    
#define I_T_NEXUS_LOSS_OCCURRED						   0x2907  // DTLPWROMAEBKVF  
#define L_EC_UNCORRECTABLE_ERROR					   0x1105  //     WRO   B     
#define LAMP_FAILURE							   0x6000  //                 
#define LOCATE_OPERATION_FAILURE					   0x1407  //  T              
#define LOCATE_OPERATION_IN_PROGRESS					   0x0019  //  T              
#define LOG_COUNTER_AT_MAXIMUM						   0x5B02  // DTLPWROM   K    
#define LOG_EXCEPTION							   0x5B00  // DTLPWROM   K    
#define LOG_LIST_CODES_EXHAUSTED					   0x5B03  // DTLPWROM   K    
#define LOG_PARAMETERS_CHANGED						   0x2A02  // DTL WROMAE K    
#define LOGICAL_BLOCK_ADDRESS_OUT_OF_RANGE				   0x2100  // DT  WROM  BK    
#define LOGICAL_UNIT_COMMUNICATION_CRC_ERROR__ULTRA_DMA_32_		   0x0803  // DT   ROM  BK    
#define LOGICAL_UNIT_COMMUNICATION_FAILURE				   0x0800  // DTL WROMAEBKVF  
#define LOGICAL_UNIT_COMMUNICATION_PARITY_ERROR				   0x0802  // DTL WROMAEBKVF  
#define LOGICAL_UNIT_COMMUNICATION_TIME_OUT				   0x0801  // DTL WROMAEBKVF  
#define LOGICAL_UNIT_DOES_NOT_RESPOND_TO_SELECTION			   0x0500  // DTL WROMAEBKVF  
#define LOGICAL_UNIT_FAILED_SELF_CONFIGURATION				   0x4C00  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_FAILED_SELF_TEST					   0x3E03  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_FAILURE						   0x3E01  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_FAILURE_PREDICTION_THRESHOLD_EXCEEDED		   0x5D02  //      R          
#define LOGICAL_UNIT_HAS_NOT_SELF_CONFIGURED_YET			   0x3E00  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_IS_IN_PROCESS_OF_BECOMING_READY			   0x0401  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_NOT_ACCESSIBLE__ASYMMETRIC_ACCESS_STATE_0xTRANSITI	   ON040A  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_NOT_ACCESSIBLE__TARGET_PORT_IN_STANDBY_STATE	   0x040B  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_NOT_ACCESSIBLE__TARGET_PORT_IN_UNAVAILABLE_STATE	   0x040C  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_NOT_CONFIGURED					   0x6800  //         A       
#define LOGICAL_UNIT_NOT_READY__AUXILIARY_MEMORY_NOT_ACCESSIBLE		   0x0410  // DT  WROM  B     
#define LOGICAL_UNIT_NOT_READY__CAUSE_NOT_REPORTABLE			   0x0400  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_NOT_READY__FORMAT_IN_PROGRESS			   0x0404  // DTL  RO   B     
#define LOGICAL_UNIT_NOT_READY__INITIALIZING_COMMAND_REQUIRED		   0x0402  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_NOT_READY__LONG_WRITE_IN_PROGRESS			   0x0408  //      R          
#define LOGICAL_UNIT_NOT_READY__MANUAL_INTERVENTION_REQUIRED		   0x0403  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_NOT_READY__NOTIFY__ENABLE_SPINUP__REQUIRED		   0x0411  // DT  WROMAEB VF  
#define LOGICAL_UNIT_NOT_READY__OFFLINE					   0x0412  //        M    V   
#define LOGICAL_UNIT_NOT_READY__OPERATION_IN_PROGRESS			   0x0407  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_NOT_READY__REBUILD_IN_PROGRESS			   0x0405  // DT  W OMA BK    
#define LOGICAL_UNIT_NOT_READY__RECALCULATION_IN_PROGRESS		   0x0406  // DT  W OMA BK    
#define LOGICAL_UNIT_NOT_READY__SELF_TEST_IN_PROGRESS			   0x0409  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_NOT_SUPPORTED					   0x2500  // DTLPWROMAEBKVF  
#define LOGICAL_UNIT_SOFTWARE_WRITE_PROTECTED				   0x2702  // DT  WRO   BK    
#define LOGICAL_UNIT_UNABLE_TO_UPDATE_SELF_TEST_LOG			   0x3E04  // DTLPWROMAEBKVF  
#define LOW_POWER_CONDITION_ON						   0x5E00  // DTLPWRO A  K    
#define MECHANICAL_POSITIONING_ERROR					   0x1501  // DTL WROM  BK    
#define MECHANICAL_POSITIONING_OR_CHANGER_ERROR				   0x3B16  //      R          
#define MEDIA_FAILURE_PREDICTION_THRESHOLD_EXCEEDED			   0x5D01  //      R    B     
#define MEDIA_LOAD_OR_EJECT_FAILED					   0x5300  // DTL WROM  BK    
#define MEDIA_REGION_CODE_IS_MISMATCHED_TO_LOGICAL_UNIT_REGION		   0x6F04  //      R          
#define MEDIUM_AUXILIARY_MEMORY_ACCESSIBLE				   0x3F11  // DT  WROM  B     
#define MEDIUM_DESTINATION_ELEMENT_FULL					   0x3B0D  // DT  WROM  BK    
#define MEDIUM_FORMAT_CORRUPTED						   0x3100  // DT  WRO   BK    
#define MEDIUM_LOADABLE							   0x3F10  // DT  WROM  B     
#define MEDIUM_MAGAZINE_INSERTED					   0x3B13  // DT  WROM  BK    
#define MEDIUM_MAGAZINE_LOCKED						   0x3B14  // DT  WROM  BK    
#define MEDIUM_MAGAZINE_NOT_ACCESSIBLE					   0x3B11  // DT  WROM  BK    
#define MEDIUM_MAGAZINE_REMOVED						   0x3B12  // DT  WROM  BK    
#define MEDIUM_MAGAZINE_UNLOCKED					   0x3B15  // DT  WROM  BK    
#define MEDIUM_NOT_FORMATTED						   0x3010  //      R          
#define MEDIUM_NOT_PRESENT						   0x3A00  // DTL WROM  BK    
#define MEDIUM_NOT_PRESENT___LOADABLE					   0x3A03  // DT  WROM  B     
#define MEDIUM_NOT_PRESENT___MEDIUM_AUXILIARY_MEMORY_ACCESSIBLE		   0x3A04  // DT  WROM  B     
#define MEDIUM_NOT_PRESENT___TRAY_CLOSED				   0x3A01  // DT  WROM  BK    
#define MEDIUM_NOT_PRESENT___TRAY_OPEN					   0x3A02  // DT  WROM  BK    
#define MEDIUM_REMOVAL_PREVENTED					   0x5302  // DT  WROM  BK    
#define MEDIUM_SOURCE_ELEMENT_EMPTY					   0x3B0E  // DT  WROM  BK    
#define MESSAGE_ERROR							   0x4300  // DTLPWROMAEBKVF  
#define MICROCODE_HAS_BEEN_CHANGED					   0x3F01  // DTLPWROMAEBKVF  
#define MISCOMPARE_DURING_VERIFY_OPERATION				   0x1D00  // DT  WRO   BK    
#define MISCORRECTED_ERROR						   0x110A  // DT    O   BK    
#define MODE_PARAMETERS_CHANGED						   0x2A01  // DTL WROMAEBKVF  
#define MODIFICATION_OF_LOGICAL_UNIT_FAILED				   0x6703  //         A       
#define MULTIPLE_LOGICAL_UNIT_FAILURES					   0x6901  //         A       
#define MULTIPLE_PERIPHERAL_DEVICES_SELECTED				   0x0700  // DTL WROM  BK    
#define MULTIPLE_READ_ERRORS						   0x1103  // DT  W O   BK    
#define MULTIPLY_ASSIGNED_LOGICAL_UNIT					   0x6709  //         A       
#define NAK_RECEIVED							   0x4B04  // DT PWROMAEBK    
#define NO_ADDITIONAL_SENSE_INFORMATION					   0x0000  // DTLPWROMAEBKVF  
#define NO_CURRENT_AUDIO_STATUS_TO_RETURN				   0x0015  //      R          
#define NO_DEFECT_SPARE_LOCATION_AVAILABLE				   0x3200  // D   W O   BK    
#define NO_GAP_FOUND							   0x1109  //  T              
#define NO_INDEX_SECTOR_SIGNAL						   0x0100  // D   W O   BK    
#define NO_MORE_TRACK_RESERVATIONS_ALLOWED				   0x7205  //      R          
#define NO_REFERENCE_POSITION_FOUND					   0x0600  // D   WROM  BK    
#define NO_SEEK_COMPLETE						   0x0200  // D   WROM  BK    
#define NO_WRITE_CURRENT						   0x0301  //  T              
#define NONCE_NOT_UNIQUE						   0x2406  //              F  
#define NONCE_TIMESTAMP_OUT_OF_RANGE					   0x2407  //              F  
#define NOT_READY_TO_READY_CHANGE__MEDIUM_MAY_HAVE_CHANGED		   0x2800  // DTLPWROMAEBKVF  
#define NOT_RESERVED							   0x2C0B  //  T              
#define OPERATION_IN_PROGRESS						   0x0016  // DTLPWROMAEBKVF  
#define OPERATOR_MEDIUM_REMOVAL_REQUEST					   0x5A01  // DT  WROM  BK    
#define OPERATOR_REQUEST_OR_STATE_CHANGE_INPUT				   0x5A00  // DTLPWROM  BK    
#define OPERATOR_SELECTED_WRITE_PERMIT					   0x5A03  // DT  WRO A BK    
#define OPERATOR_SELECTED_WRITE_PROTECT					   0x5A02  // DT  WRO A BK    
#define OUT_OF_FOCUS							   0x6102  //                 
#define OVERLAPPED_COMMANDS_ATTEMPTED					   0x4E00  // DTLPWROMAEBKVF  
#define OVERWRITE_ERROR_ON_UPDATE_IN_PLACE				   0x2D00  //  T              
#define Obsolete							   0x2005  //  T              
// #define Obsolete							   0x2402  //  T              
// #define Obsolete							   0x2403  //  T              
#define PACKET_DOES_NOT_FIT_IN_AVAILABLE_SPACE				   0x6301  //      R          
#define PAPER_JAM							   0x3B05  //   L             
#define PARAMETER_LIST_LENGTH_ERROR					   0x1A00  // DTLPWROMAEBKVF  
#define PARAMETER_NOT_SUPPORTED						   0x2601  // DTLPWROMAEBKVF  
#define PARAMETER_VALUE_INVALID						   0x2602  // DTLPWROMAEBKVF  
#define PARAMETERS_CHANGED						   0x2A00  // DTL WROMAEBKVF  
#define PARITY_DATA_MISMATCH						   0x6902  //         A       
#define PARTIAL_DEFECT_LIST_TRANSFER					   0x1F00  // D     O    K    
#define PARTITION_OR_COLLECTION_CONTAINS_USER_OBJECTS			   0x2C0A  //              F  
#define PERIPHERAL_DEVICE_WRITE_FAULT					   0x0300  // DTL W O   BK    
#define PERMANENT_WRITE_PROTECT						   0x2705  //  T   R          
#define PERSISTENT_PREVENT_CONFLICT					   0x2C06  //      R          
#define PERSISTENT_WRITE_PROTECT					   0x2704  //  T   R          
#define PHY_TEST_FUNCTION_IN_PROGRESS					   0x4706  // DT     MAEBKVF  
#define POSITION_ERROR_RELATED_TO_TIMING				   0x5002  //  T              
#define POSITION_PAST_BEGINNING_OF_MEDIUM				   0x3B0C  //  T              
#define POSITION_PAST_END_OF_MEDIUM					   0x3B0B  //                 
#define POSITIONING_ERROR_DETECTED_BY_READ_OF_MEDIUM			   0x1502  // DT  WRO   BK    
#define POWER_CALIBRATION_AREA_ALMOST_FULL				   0x7301  //      R          
#define POWER_CALIBRATION_AREA_ERROR					   0x7303  //      R          
#define POWER_CALIBRATION_AREA_IS_FULL					   0x7302  //      R          
#define POWER_ON_OCCURRED						   0x2901  // DTLPWROMAEBKVF  
#define POWER_ON__RESET__OR_BUS_DEVICE_RESET_OCCURRED			   0x2900  // DTLPWROMAEBKVF  
#define POWER_STATE_CHANGE_TO_ACTIVE					   0x5E41  //           B     
#define POWER_STATE_CHANGE_TO_DEVICE_CONTROL				   0x5E47  //           BK    
#define POWER_STATE_CHANGE_TO_IDLE					   0x5E42  //           B     
#define POWER_STATE_CHANGE_TO_SLEEP					   0x5E45  //           B     
#define POWER_STATE_CHANGE_TO_STANDBY					   0x5E43  //           B     
#define POWER_ON_OR_SELF_TEST_FAILURE__SHOULD_USE_40_NN_		   0x4200  // D               
#define PREVIOUS_BUSY_STATUS						   0x2C07  // DTLPWROMAEBKVF  
#define PREVIOUS_RESERVATION_CONFLICT_STATUS				   0x2C09  // DTLPWROM EBKVF  
#define PREVIOUS_TASK_SET_FULL_STATUS					   0x2C08  // DTLPWROMAEBKVF  
#define PRIMARY_DEFECT_LIST_NOT_FOUND					   0x1C01  // D     O   BK    
#define PRIORITY_CHANGED						   0x2A08  // DT  WROMAEBKVF  
#define PROGRAM_MEMORY_AREA_IS_FULL					   0x7305  //      R          
#define PROGRAM_MEMORY_AREA_UPDATE_FAILURE				   0x7304  //      R          
#define PROTOCOL_SERVICE_CRC_ERROR					   0x4705  // DTLPWROMAEBKVF  
#define QUOTA_ERROR							   0x5507  //              F  
#define RAM_FAILURE__SHOULD_USE_40_NN_					   0x4000  // D               
#define RANDOM_POSITIONING_ERROR					   0x1500  // DTL WROM  BK    
#define READ_ERROR___FAILED_RETRANSMISSION_REQUEST			   0x1113  // DTLPWROMAEBKVF  
#define READ_ERROR___LOSS_OF_STREAMING					   0x1111  //      R          
#define READ_OF_SCRAMBLED_SECTOR_WITHOUT_AUTHENTICATION			   0x6F03  //      R          
#define READ_PAST_BEGINNING_OF_MEDIUM					   0x3B0A  //                 
#define READ_PAST_END_OF_MEDIUM						   0x3B09  //                 
#define READ_PAST_END_OF_USER_OBJECT					   0x3B17  //              F  
#define READ_RETRIES_EXHAUSTED						   0x1101  // DT  WRO   BK    
#define REBUILD_FAILURE_OCCURRED					   0x6C00  //         A       
#define RECALCULATE_FAILURE_OCCURRED					   0x6D00  //         A       
#define RECORD_NOT_FOUND						   0x1401  // DT  WRO   BK    
#define RECORD_NOT_FOUND___DATA_AUTO_REALLOCATED			   0x1406  // DT  W O   BK    
#define RECORD_NOT_FOUND___RECOMMEND_REASSIGNMENT			   0x1405  // DT  W O   BK    
#define RECORDED_ENTITY_NOT_FOUND					   0x1400  // DTL WRO   BK    
#define RECOVERED_DATA___DATA_AUTO_REALLOCATED				   0x1802  // D   WRO   BK    
#define RECOVERED_DATA___RECOMMEND_REASSIGNMENT				   0x1805  // D   WRO   BK    
#define RECOVERED_DATA___RECOMMEND_REWRITE				   0x1806  // D   WRO   BK    
#define RECOVERED_DATA_USING_PREVIOUS_SECTOR_ID				   0x1705  // D   WRO   BK    
#define RECOVERED_DATA_WITH_CIRC					   0x1803  //      R          
#define RECOVERED_DATA_WITH_ECC___DATA_REWRITTEN			   0x1807  // D   W O   BK    
#define RECOVERED_DATA_WITH_ERROR_CORR____RETRIES_APPLIED		   0x1801  // D   WRO   BK    
#define RECOVERED_DATA_WITH_ERROR_CORRECTION_APPLIED			   0x1800  // DT  WRO   BK    
#define RECOVERED_DATA_WITH_L_EC					   0x1804  //      R          
#define RECOVERED_DATA_WITH_LINKING					   0x1808  //      R          
#define RECOVERED_DATA_WITH_NEGATIVE_HEAD_OFFSET			   0x1703  // DT  WRO   BK    
#define RECOVERED_DATA_WITH_NO_ERROR_CORRECTION_APPLIED			   0x1700  // DT  WRO   BK    
#define RECOVERED_DATA_WITH_POSITIVE_HEAD_OFFSET			   0x1702  // DT  WRO   BK    
#define RECOVERED_DATA_WITH_RETRIES					   0x1701  // DT  WRO   BK    
#define RECOVERED_DATA_WITH_RETRIES_AND_OR_CIRC_APPLIED			   0x1704  //     WRO   B     
#define RECOVERED_DATA_WITHOUT_ECC___DATA_AUTO_REALLOCATED		   0x1706  // D   W O   BK    
#define RECOVERED_DATA_WITHOUT_ECC___DATA_REWRITTEN			   0x1709  // D   WRO   BK    
#define RECOVERED_DATA_WITHOUT_ECC___RECOMMEND_REASSIGNMENT		   0x1707  // D   WRO   BK    
#define RECOVERED_DATA_WITHOUT_ECC___RECOMMEND_REWRITE			   0x1708  // D   WRO   BK    
#define RECOVERED_ID_WITH_ECC_CORRECTION				   0x1E00  // D   W O   BK    
#define REDUNDANCY_GROUP_CREATED_OR_MODIFIED				   0x3F06  // DT  WROMAEB     
#define REDUNDANCY_GROUP_DELETED					   0x3F07  // DT  WROMAEB     
#define REDUNDANCY_LEVEL_GOT_BETTER					   0x6B01  //         A       
#define REDUNDANCY_LEVEL_GOT_WORSE					   0x6B02  //         A       
#define REGISTRATIONS_PREEMPTED						   0x2A05  // DTLPWROMAE      
#define REMOVE_OF_LOGICAL_UNIT_FAILED					   0x6705  //         A       
#define REPORTED_LUNS_DATA_HAS_CHANGED					   0x3F0E  // DTLPWROMAE      
#define REPOSITION_ERROR						   0x3B08  //  T              
#define RESERVATIONS_PREEMPTED						   0x2A03  // DTLPWROMAE K    
#define RESERVATIONS_RELEASED						   0x2A04  // DTLPWROMAE      
#define REWIND_OPERATION_IN_PROGRESS					   0x001A  //  T              
#define RIBBON__INK__OR_TONER_FAILURE					   0x3600  //   L             
#define RMA_PMA_IS_ALMOST_FULL						   0x7306  //      R          
#define ROUNDED_PARAMETER						   0x3700  // DTL WROMAEBKVF  
#define RPL_STATUS_CHANGE						   0x5C00  // D     O         
#define SAVING_PARAMETERS_NOT_SUPPORTED					   0x3900  // DTL WROMAE K    
#define SCAN_HEAD_POSITIONING_ERROR					   0x6200  //                 
#define SCSI_BUS_RESET_OCCURRED						   0x2902  // DTLPWROMAEBKVF  
#define SCSI_PARITY_ERROR						   0x4700  // DTLPWROMAEBKVF  
#define SCSI_PARITY_ERROR_DETECTED_DURING_ST_DATA_PHASE			   0x4702  // DTLPWROMAEBKVF  
#define SCSI_TO_HOST_SYSTEM_INTERFACE_FAILURE				   0x5400  //    P            
#define SECURITY_AUDIT_VALUE_FROZEN					   0x2404  //              F  
#define SECURITY_WORKING_KEY_FROZEN					   0x2405  //              F  
#define SELECT_OR_RESELECT_FAILURE					   0x4500  // DTLPWROMAEBKVF  
#define SEQUENTIAL_POSITIONING_ERROR					   0x3B00  //  TL             
#define SERVO_IMPENDING_FAILURE_ACCESS_TIMES_TOO_HIGH			   0x5D45  // D         B     
#define SERVO_IMPENDING_FAILURE_CHANNEL_PARAMETRICS			   0x5D47  // D         B     
#define SERVO_IMPENDING_FAILURE_CONTROLLER_DETECTED			   0x5D48  // D         B     
#define SERVO_IMPENDING_FAILURE_DATA_ERROR_RATE_TOO_HIGH		   0x5D42  // D         B     
#define SERVO_IMPENDING_FAILURE_DRIVE_CALIBRATION_RETRY_COUNT		   0x5D4C  // D         B     
#define SERVO_IMPENDING_FAILURE_DRIVE_ERROR_RATE_TOO_HIGH		   0x5D41  // D         B     
#define SERVO_IMPENDING_FAILURE_GENERAL_HARD_DRIVE_FAILURE		   0x5D40  // D         B     
#define SERVO_IMPENDING_FAILURE_SEEK_ERROR_RATE_TOO_HIGH		   0x5D43  // D         B     
#define SERVO_IMPENDING_FAILURE_SEEK_TIME_PERFORMANCE			   0x5D4A  // D         B     
#define SERVO_IMPENDING_FAILURE_SPIN_UP_RETRY_COUNT			   0x5D4B  // D         B     
#define SERVO_IMPENDING_FAILURE_START_UNIT_TIMES_TOO_HIGH		   0x5D46  // D         B     
#define SERVO_IMPENDING_FAILURE_THROUGHPUT_PERFORMANCE			   0x5D49  // D         B     
#define SERVO_IMPENDING_FAILURE_TOO_MANY_BLOCK_REASSIGNS		   0x5D44  // D         B     
#define SESSION_FIXATION_ERROR						   0x7200  //      R          
#define SESSION_FIXATION_ERROR___INCOMPLETE_TRACK_IN_SESSION		   0x7203  //      R          
#define SESSION_FIXATION_ERROR_WRITING_LEAD_IN				   0x7201  //      R          
#define SESSION_FIXATION_ERROR_WRITING_LEAD_OUT				   0x7202  //      R          
#define SET_CAPACITY_OPERATION_IN_PROGRESS				   0x001B  //  T              
#define SET_TARGET_PORT_GROUPS_COMMAND_FAILED				   0x670A  // DTLPWROMAEBKVF  
#define SETMARK_DETECTED						   0x0003  //  T              
#define SLEW_FAILURE							   0x3B04  //   L             
#define SOME_COMMANDS_CLEARED_BY_ISCSI_PROTOCOL_EVENT			   0x477F  // DT PWROMAEBK    
#define SPARE_AREA_EXHAUSTION_PREDICTION_THRESHOLD_EXCEEDED		   0x5D03  //      R          
#define SPARE_CREATED_OR_MODIFIED					   0x3F08  // DT  WROMAEB     
#define SPARE_DELETED							   0x3F09  // DT  WROMAEB     
#define SPINDLE_IMPENDING_FAILURE_ACCESS_TIMES_TOO_HIGH			   0x5D55  // D         B     
#define SPINDLE_IMPENDING_FAILURE_CHANNEL_PARAMETRICS			   0x5D57  // D         B     
#define SPINDLE_IMPENDING_FAILURE_CONTROLLER_DETECTED			   0x5D58  // D         B     
#define SPINDLE_IMPENDING_FAILURE_DATA_ERROR_RATE_TOO_HIGH		   0x5D52  // D         B     
#define SPINDLE_IMPENDING_FAILURE_DRIVE_CALIBRATION_RETRY_COUNT		   0x5D5C  // D         B     
#define SPINDLE_IMPENDING_FAILURE_DRIVE_ERROR_RATE_TOO_HIGH		   0x5D51  // D         B     
#define SPINDLE_IMPENDING_FAILURE_GENERAL_HARD_DRIVE_FAILURE		   0x5D50  // D         B     
#define SPINDLE_IMPENDING_FAILURE_SEEK_ERROR_RATE_TOO_HIGH		   0x5D53  // D         B     
#define SPINDLE_IMPENDING_FAILURE_SEEK_TIME_PERFORMANCE			   0x5D5A  // D         B     
#define SPINDLE_IMPENDING_FAILURE_SPIN_UP_RETRY_COUNT			   0x5D5B  // D         B     
#define SPINDLE_IMPENDING_FAILURE_START_UNIT_TIMES_TOO_HIGH		   0x5D56  // D         B     
#define SPINDLE_IMPENDING_FAILURE_THROUGHPUT_PERFORMANCE		   0x5D59  // D         B     
#define SPINDLE_IMPENDING_FAILURE_TOO_MANY_BLOCK_REASSIGNS		   0x5D54  // D         B     
#define SPINDLE_SERVO_FAILURE						   0x0903  //     WRO         
#define SPINDLES_NOT_SYNCHRONIZED					   0x5C02  // D     O         
#define SPINDLES_SYNCHRONIZED						   0x5C01  // D     O         
#define STANDBY_CONDITION_ACTIVATED_BY_COMMAND				   0x5E04  // DTLPWRO A  K    
#define STANDBY_CONDITION_ACTIVATED_BY_TIMER				   0x5E02  // DTLPWRO A  K    
#define STATE_CHANGE_HAS_OCCURRED					   0x6B00  //         A       
#define SYNCHRONOUS_DATA_TRANSFER_ERROR					   0x1B00  // DTLPWROMAEBKVF  
#define SYSTEM_BUFFER_FULL						   0x5501  // D     O   BK    
#define SYSTEM_RESOURCE_FAILURE						   0x5500  //    P            
#define TAGGED_OVERLAPPED_COMMANDS__NN___TASK_TAG_			   0x4DNN  // DTLPWROMAEBKVF  
#define TAPE_LENGTH_ERROR						   0x3300  //  T              
#define TAPE_OR_ELECTRONIC_VERTICAL_FORMS_UNIT_NOT_READY		   0x3B03  //   L             
#define TAPE_POSITION_ERROR_AT_BEGINNING_OF_MEDIUM			   0x3B01  //  T              
#define TAPE_POSITION_ERROR_AT_END_OF_MEDIUM				   0x3B02  //  T              
#define TARGET_OPERATING_CONDITIONS_HAVE_CHANGED			   0x3F00  // DTLPWROMAEBKVF  
#define THIRD_PARTY_DEVICE_FAILURE					   0x0D01  // DTLPWRO A  K    
#define THRESHOLD_CONDITION_MET						   0x5B01  // DTLPWROM   K    
#define THRESHOLD_PARAMETERS_NOT_SUPPORTED				   0x2603  // DTLPWROMAE K    
#define TIMEOUT_ON_LOGICAL_UNIT						   0x3E02  // DTLPWROMAEBKVF  
#define TIMESTAMP_CHANGED						   0x2A10  // DT     M E  V   
#define TOO_MANY_SEGMENT_DESCRIPTORS					   0x2608  // DTLPWRO    K    
#define TOO_MANY_TARGET_DESCRIPTORS					   0x2606  // DTLPWRO    K    
#define TOO_MANY_WINDOWS_SPECIFIED					   0x2C01  //                 
#define TOO_MUCH_WRITE_DATA						   0x4B02  // DT PWROMAEBK    
#define TRACK_FOLLOWING_ERROR						   0x0900  // DT  WRO   B     
#define TRACKING_SERVO_FAILURE						   0x0901  //     WRO    K    
#define TRANSCEIVER_MODE_CHANGED_TO_LVD					   0x2906  // DTLPWROMAEBKVF  
#define TRANSCEIVER_MODE_CHANGED_TO_SINGLE_ENDED			   0x2905  // DTLPWROMAEBKVF  
#define UNABLE_TO_ACQUIRE_VIDEO						   0x6101  //                 
#define UNABLE_TO_RECOVER_TABLE_OF_CONTENTS				   0x5700  //      R          
#define UNEXPECTED_INEXACT_SEGMENT					   0x260A  // DTLPWRO    K    
#define UNLOAD_TAPE_FAILURE						   0x5301  //  T              
#define UNREACHABLE_COPY_TARGET						   0x0804  // DTLPWRO    K    
#define UNRECOVERED_READ_ERROR						   0x1100  // DT  WRO   BK    
#define UNRECOVERED_READ_ERROR___AUTO_REALLOCATE_FAILED			   0x1104  // D   W O   BK    
#define UNRECOVERED_READ_ERROR___RECOMMEND_REASSIGNMENT			   0x110B  // D   W O   BK    
#define UNRECOVERED_READ_ERROR___RECOMMEND_REWRITE_THE_DATA		   0x110C  // D   W O   BK    
#define UNSUCCESSFUL_SOFT_RESET						   0x4600  // DTLPWROM  BK    
#define UNSUPPORTED_ENCLOSURE_FUNCTION					   0x3501  // DTLPWROMAEBKVF  
#define UNSUPPORTED_SEGMENT_DESCRIPTOR_TYPE_CODE			   0x2609  // DTLPWRO    K    
#define UNSUPPORTED_TARGET_DESCRIPTOR_TYPE_CODE				   0x2607  // DTLPWRO    K    
#define UPDATED_BLOCK_READ						   0x5900  //       O         
#define VERIFY_OPERATION_IN_PROGRESS					   0x001C  //  T              
#define VIDEO_ACQUISITION_ERROR						   0x6100  //                 
#define VOLTAGE_FAULT							   0x6500  // DTLPWROMAEBKVF  
#define VOLUME_SET_CREATED_OR_MODIFIED					   0x3F0A  // DT  WROMAEBK    
#define VOLUME_SET_DEASSIGNED						   0x3F0C  // DT  WROMAEBK    
#define VOLUME_SET_DELETED						   0x3F0B  // DT  WROMAEBK    
#define VOLUME_SET_REASSIGNED						   0x3F0D  // DT  WROMAEBK    
#define WARNING								   0x0B00  // DTLPWROMAEBKVF  
#define WARNING___BACKGROUND_MEDIUM_SCAN_FAILED				   0x0B05  // DTLPWROMAEBKVF  
#define WARNING___BACKGROUND_PRE_SCAN_FAILED				   0x0B04  // DTLPWROMAEBKVF  
#define WARNING___BACKGROUND_SELF_TEST_FAILED				   0x0B03  // DTLPWROMAEBKVF  
#define WARNING___ENCLOSURE_DEGRADED					   0x0B02  // DTLPWROMAEBKVF  
#define WARNING___SPECIFIED_TEMPERATURE_EXCEEDED			   0x0B01  // DTLPWROMAEBKVF  
#define WORM_MEDIUM___OVERWRITE_ATTEMPTED				   0x300C  //  T              
#define WRITE_APPEND_ERROR						   0x5000  //  T              
#define WRITE_APPEND_POSITION_ERROR					   0x5001  //  T              
#define WRITE_ERROR							   0x0C00  //  T   R          
#define WRITE_ERROR___AUTO_REALLOCATION_FAILED				   0x0C02  // D   W O   BK    
#define WRITE_ERROR___LOSS_OF_STREAMING					   0x0C09  //      R          
#define WRITE_ERROR___NOT_ENOUGH_UNSOLICITED_DATA			   0x0C0D  // DTLPWROMAEBKVF  
#define WRITE_ERROR___PADDING_BLOCKS_ADDED				   0x0C0A  //      R          
#define WRITE_ERROR___RECOMMEND_REASSIGNMENT				   0x0C03  // D   W O   BK    
#define WRITE_ERROR___RECOVERED_WITH_AUTO_REALLOCATION			   0x0C01  //            K    
#define WRITE_ERROR___RECOVERY_FAILED					   0x0C08  //      R          
#define WRITE_ERROR___RECOVERY_NEEDED					   0x0C07  //      R          
#define WRITE_ERROR___UNEXPECTED_UNSOLICITED_DATA			   0x0C0C  // DTLPWROMAEBKVF  
#define WRITE_PROTECTED							   0x2700  // DT  WRO   BK    
#define ZONED_FORMATTING_FAILED_DUE_TO_SPARE_LINKING			   0x3102  //      R          




#endif /* !__SENSE_CODES_H */
