#ifndef _LIBERIC_MISC_H
#define _LIBERIC_MISC_H

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>
#include <openssl/bio.h>
#include <pp/base.h>
#include <pp/vector.h>
#include <liberic_session.h>
// really needed? #include <lara.h>

#define KEYSYM_DELI       '+'
#define KEYSYM_DELISTR    "+"
#define APPLPARAM_DELI    ':'
#define APPLPARAM_DELISTR ":"
#define KEYCONFIRM_STR    "confirm"

#define KEYPARSER_WITHOUT_DELIS		0
#define KEYPARSER_WITH_DELIS		1

int eric_misc_init(void);
void eric_misc_cleanup(void);
int eric_misc_reset_is_running(void);
int eric_misc_trigger_board_reset(eric_session_int_id_t session);
int eric_misc_get_host_power(int * host_power);
int eric_misc_get_host_pwrsupplypower(int * host_pwrsupply_power);
    
/**
 * Get the name of the device
 *
 * @return the "official" name of this device
 *         caller has to free the result, will never be NULL
 */
char* eric_misc_get_boardname(void);

int eric_misc_get_panel_id(void);
int eric_misc_set_panel_id(unsigned int panel_id);
    
char * eric_misc_get_key_appletparam(const char * keystring, char ** errortok, int include_delis);
vector_t * eric_misc_key_get_keysequence(const char * key, char ** errortok);

char * eric_misc_get_hardware_rev_str(void);
unsigned char eric_misc_get_hardware_rev_int(void);

#ifdef PP_FEAT_USBPOWERED
/**
 * check if we are running on external power supply
 *
 * @return	0/1 if no/yes, -1 on error
 */
int eric_misc_external_power_status(void);
#endif

int pp_misc_get_kvm_node(void);
int pp_misc_get_kvm_node_cnt(void);
/******************************************************************************
 *  keyparser stuff
 */

#include <pp/vector.h>

#define APPLPARAM_DELI    ':'
#define APPLPARAM_DELISTR ":"
#define KEYCONFIRM_STR    "confirm"

/**
 *  * The following constants name our various delemitter symbols
 *   * ATTENTION: make sure they do not interfere with keycode
 *    * constants defined in keytable.c
 *     */
#define KEYDELI_ADD             (0xf0)
#define KEYDELI_SEPERATE        (0xf1)
#define KEYDELI_PAUSE           (0xf2)
#define KEYDELI_RELEASE_LAST    (0xf3)

#ifdef __cplusplus
}
#endif

#endif /* _LIBERIC_MISC_H */
