#include <sys/types.h>
#include <regex.h>
#include <string.h>
#include <stdio.h>
#include <pp_kernel_common.h>
#include <pp/base.h>
#include <pp/cfg.h>
#include <liberic_notify.h>

#include "list.h"
#include "nfs.h"
#include "smtp.h"
#include "snmptrap.h"
#include "rsyslog.h"
#include "utils.h"

static int initialized = 0;

#if defined(PP_FEAT_PROPCHANGE)
static void propchange_handler(pp_propchange_listener_t * listener, u_short prop, u_short prop_flags);

PP_DECLARE_PROPCHANGE_LISTENER(propchange_listener, propchange_handler);
#endif /* PP_FEAT_PROPCHANGE */

int
eric_notify_init(notify_init_t flags)
{
    if (!initialized) {
	if (PP_FAILED(list_log_init())) return PP_ERR;
	if (PP_FAILED(smtp_log_init())) return PP_ERR;
#if defined(PP_FEAT_SNMP_TRAP) || defined(PP_FEAT_NETSNMP_TRAP)
	if (PP_FAILED(snmp_log_init())) return PP_ERR;
#endif /* PP_FEAT_SNMP_TRAP */
	if (PP_FAILED(nfs_log_init()))  {
	    pp_log("WARNING: error during initialising nfs event log !\n") ;
	    // don't stop the init of the eric process.
	    // otherwise the user have to reset to defaults if the nfs server is down.
	    // return PP_ERR;
	}
#if defined (PP_FEAT_REMOTE_SYSLOG)
	if (PP_FAILED(syslog_log_init())) return PP_ERR;
#endif /* PP_FEAT_REMOTE_SYSLOG  */

#if defined(PP_FEAT_PROPCHANGE)
	if (flags == NOTIFY_INIT_WITH_HOST_TRAPS) {
	    pp_propchange_add(&propchange_listener, PP_PROP_PWR_ON);
	    pp_propchange_add(&propchange_listener, PP_PROP_PWR_OFF);
	    pp_propchange_add(&propchange_listener, PP_PROP_RST);
	}
#else
        (void)flags;
#endif /* PP_FEAT_PROPCHANGE */

	pp_cfg_add_change_listener(nfs_log_reconf_ch, "log.nfs");

	initialized = 1;
    }
    
    return PP_SUC;
}

void
eric_notify_cleanup(void)
{
    pp_cfg_rem_change_listener(nfs_log_reconf_ch, "log.nfs");
#if defined(PP_FEAT_PROPCHANGE)
    pp_propchange_remove_all(&propchange_listener);
#endif /* PP_FEAT_PROPCHANGE */
    nfs_log_cleanup();
    snmp_log_cleanup();
    smtp_log_cleanup();
    nfs_log_cleanup();
#if defined (PP_FEAT_REMOTE_SYSLOG)
    syslog_log_cleanup();
#endif /* PP_FEAT_REMOTE_SYSLOG  */
    initialized = 0;
}

#if defined(PP_FEAT_PROPCHANGE)
static void
propchange_handler(pp_propchange_listener_t * listener UNUSED, u_short prop, u_short prop_flags UNUSED)
{
    log_event_t event;
 
    switch (prop) {
      case PP_PROP_PWR_ON:
      case PP_PROP_PWR_OFF:	  
          event.trapoid = "HostPower";
          eric_notify_post_event(&event, "host", PP_NOTIFY_EVENT_LEGACY);
	  break;
      case PP_PROP_RST:	  
          event.trapoid = "HostReset";
	  eric_notify_post_event(&event, "host", PP_NOTIFY_EVENT_LEGACY);
	  break;
      default:
	  pp_log("%s(): Unhandled property %hu received.\n", ___F, prop);
    }
}
#endif /* PP_FEAT_PROPCHANGE */
