#ifndef _LIBERIC_NOTIFY_H
#define _LIBERIC_NOTIFY_H

#include <pp/base.h>
#include <liberic_session.h>

#define PP_NOTIFY_MAX_EVENT_NAME_LEN 63
#define PP_NOTIFY_MAX_EVENT_DESC_LEN 255

typedef struct {
    const char* loginname;
    const char* remote_host;
    time_t session_duration;
} logintrapdata_t;

typedef struct {
    const char* evnt_time;
    const char* alert_host;
    const char* evnt_type;
    const char* evnt_desc;    
} ipmitrapdata_t;

typedef struct {
    const char* trap_desc;  
} generictrap_t;

typedef struct {
	const char * portname;
	const char * portstatus;
}porttrapdata_t;

typedef struct {
	const char * targetuser;
	const char * username;
}usertrapdata_t;

typedef struct {
	const char * groupname;
	const char * username;
}grouptrapdata_t;

typedef struct {
	const char * imageversion;
	const char * status;
}upgradetrapdata_t;

typedef struct {
	const char * fileversion;
	const char * type;
	const char * status;
} backuprestoretrapdata_t;

typedef struct {
	const char * outletname;
	const char * status;
} powersupplystatustrapdata_t;

typedef struct {
	const char * username;
}passwordchangedtrapdata_t;

typedef struct {    
    const char* trapoid;
    const char* longname;
    union {
	logintrapdata_t logintrapdata;
	ipmitrapdata_t  ipmitrapdata; 
	generictrap_t   generictrapdata;
	logintrapdata_t logininfo;
	porttrapdata_t  porttrapdata;
	usertrapdata_t usertrapdata;
	grouptrapdata_t grouptrapdata;
	upgradetrapdata_t upgradetrapdata;
	backuprestoretrapdata_t backuprestoretrapdata;
	passwordchangedtrapdata_t passwordchangedtrap;
	powersupplystatustrapdata_t powersupplystatustrapdata;
    } eventdata;
    u_int eventcode;
    const char * objectname;
    const char * objectinstance;
    const char * trapname;
} log_event_t;

typedef enum {
    NOTIFY_INIT_DEFAULT,
    NOTIFY_INIT_WITH_HOST_TRAPS
} notify_init_t;

typedef struct  evt_type_entry_t {
    char * name;
    char * longname;
    int list_enabled;
    int nfs_enabled;
    int smtp_enabled;
    int snmp_enabled;
    int syslog_enabled;
    int flags;
} evt_type_entry_t;

#define PP_NOTIFY_LIST_FORWARD		1
#define PP_NOTIFY_LIST_BACKWARD		2

#define PP_NOTIFY_EVENT_GENERIC		0
#define PP_NOTIFY_EVENT_LEGACY		1
#define PP_NOTIFY_EVENT_KX2		2

#define PP_NOTIFY_EVENT_LIST_ENABLE	(1<<0)
#define PP_NOTIFY_EVENT_SNMP_ENABLE	(1<<1)
#define PP_NOTIFY_EVENT_SMTP_ENABLE	(1<<2)
#define PP_NOTIFY_EVENT_NFS_ENABLE	(1<<3)
#define PP_NOTIFY_EVENT_SYSLOG_ENABLE   (1<<4)
#define PP_NOTIFY_EVENT_ALL_ENABLE	(PP_NOTIFY_EVENT_LIST_ENABLE \
					 | PP_NOTIFY_EVENT_SNMP_ENABLE \
					 | PP_NOTIFY_EVENT_SMTP_ENABLE \
					 | PP_NOTIFY_EVENT_NFS_ENABLE \
					 | PP_NOTIFY_EVENT_SYSLOG_ENABLE)

#define PP_NOTIFY_MAX_MSG_LEN	255

enum
{
    // System Events

    ERIC_EC_System_Startup			= 32,	// startup
    ERIC_EC_System_Shutdown			= 33,	// shutdown
    ERIC_EC_System_Run_Error			= 36,	// RunError

    ERIC_EC_System_Factory_Reset		= 39,	// FactoryReset
    ERIC_EC_System_Start_Management		= 40,	// StartManagement
    ERIC_EC_System_Stop_Management		= 41,	// StopManagement

    // Device Events

    ERIC_EC_Device_Update_Started		= 73,	// UpdateStarted
    ERIC_EC_Device_Update_Completed		= 74,	// UpdateCompleted
    ERIC_EC_Device_Config_Backup		= 75,	// ConfigBackup
    ERIC_EC_Device_Config_Restore		= 76,	// ConfigRestore
    ERIC_EC_Device_PowerSupply_Status_Changed	= 77,	// PowerSupplyStatus

    // Port Events

    ERIC_EC_Port_Status_Changed			= 84,	// PortStatus

    // User Events

    ERIC_EC_User_Added				= 96,	// UserAdded
    ERIC_EC_User_Changed			= 97,	// UserChanged
    ERIC_EC_User_Deleted			= 98,	// UserDeleted
    ERIC_EC_User_Password_Changed		= 100,	// PasswordChanged

    // Group Events

    ERIC_EC_Group_Added				= 112,	// GroupAdded
    ERIC_EC_Group_Changed			= 113,	// GroupChanged
    ERIC_EC_Group_Deleted			= 114,	// GroupDeleted
    ERIC_EC_Group_Change_Request		= 115,	// 

    // Access Events

    ERIC_EC_Access_Login			= 128,	// Login
    ERIC_EC_Access_Logout			= 129,	// Logout
    ERIC_EC_Access_Login_Failed			= 130,	// LoginFailed
    ERIC_EC_Access_Connection_Lost		= 131,	// ConnectionLost
    ERIC_EC_Access_Connection_Timeout		= 132,	// ConnectionTimeout
    ERIC_EC_Access_Port_Connect			= 137,	// PortConnect
    ERIC_EC_Access_Port_Disconnect		= 138,	// PortDisconnect

    ERIC_EC_EVENT_End,
};

int eric_notify_init(notify_init_t flags);
void eric_notify_cleanup(void);

int eric_notify_register_log_object(const char *short_name, const char *long_name, int flags);
int eric_notify_get_object_cnt(void);
evt_type_entry_t* eric_notify_get_first_event_obj(void);
evt_type_entry_t* eric_notify_get_next_event_obj(void);
evt_type_entry_t* eric_notify_get_event_object(const char *name);

void eric_notify_security_violation(eric_session_int_id_t session);
int eric_notify_post_event(const void * data, const char *evt_name, int evt_flag);

int eric_notify_show_seek_btn(struct list_head *lst_ptr, int entries_shown, int direction);

void eric_notify_list_log_clear(void);
u_int eric_notify_list_get_last_id(void);
u_int eric_notify_list_get_first_id(void);
u_int eric_notify_list_get_entry(u_int id, time_t * date_p, char ** event_p, char ** desc_p);
int eric_notify_list_get_entry_exact(u_int id, time_t * date_p, char ** event_p, char ** desc_p);
int eric_notify_list_have_more_entries(u_int id, int direction);

int eric_notify_nfs_mount(void);
int eric_notify_nfs_unmount(void);

void eric_notify_get_time_string(time_t t, char * buf, size_t buf_size);

/*
   --------------------------------------------------------------------
    @brief              Power supply change notifier
    @param             outlet = PP_HAL_KX2_DUAL_POWER_1 | PP_HAL_KX2_DUAL_POWER_2
    @return             1 (SUCCESS)   0 (ERROR)
    --------------------------------------------------------------------
*/
void eric_notify_power_supply_change(int outlet );

#endif /* _LIBERIC_NOTIFY_H */
