#include <pthread.h>
#include <pp/base.h>
#include <pp/cfg.h>
#include <pp/smtp.h>

#include "smtp.h"

int
smtp_log_init(void)
{
    return PP_SUC;
}

void
smtp_log_cleanup(void)
{
}

static void
free_mail_hdr(void *elem) {
     mail_header_t *hdr = (mail_header_t *) elem;

     free(hdr->name);
     free(hdr->val);
     free(elem);
}

int
smtp_log_event(time_t date, const char * event, const char * desc)
{    
    const char * separator = " - ";
    char * from = NULL;
    char * to = NULL;
    char * host = NULL;
    char * ipaddr = NULL;
    char* subject = NULL;
    int ret = PP_ERR;
    mail_data_t data;
    
    memset(&data, 0, sizeof(data));

    /* NOTE: in cluster mode this gets not called! */
    if (PP_SUCCED(pp_cfg_get_nodflt(&ipaddr, "network.ipaddr"))) {
	/* add ip to subject */
	asprintf(&subject, "%s%s%s", event, separator, ipaddr);
	data.subject = subject;
    } else {
	data.subject = event;
    }

    if (PP_FAILED(pp_cfg_get_nodflt(&from, "log.smtp.from"))) {
	/* HACK: use root@<ip> when "from" is not set */
	/* FIXME: ipaddr might be NULL! */
	asprintf(&from, "root@%s", ipaddr);
    }
    
    if (PP_FAILED(pp_cfg_get_nodflt(&to, "log.smtp.to"))) {
	pp_log("%s(): no \"to\" set\n", ___F);
	goto finish;
    }

    if (PP_FAILED(pp_cfg_get_nodflt(&host, "log.smtp.server"))) {
	pp_log("%s(): no SMTP server set\n", ___F);
	goto finish;
    }

    data.from = from;
    data.to = to;
    data.host = host;
    data.mail_txt = desc;
    data.time_stamp = date;

    /* add extra headers */
    {
#if defined(OEM_BELKIN)
	mail_header_t *hdr = NULL;
#endif

	data.extra_hdrs = vector_new(NULL, 3, free_mail_hdr);
	
#if defined(OEM_BELKIN)
	hdr = malloc(sizeof(mail_header_t));
	hdr->name = strdup("X-PP-Logging-Belkin");
	hdr->val = strdup("");
	vector_add(data.extra_hdrs, hdr);
#endif
    }
    
    if ((ret = pp_smtp_send_mail(&data)) != 0) {
        pp_log("%s(): pp_smtp_send_mail() failed\n", ___F);
        ret = PP_ERR;
	goto finish;
    }

    ret = PP_SUC;
        
finish:
    free(from);
    free(to);
    free(host);
    free(ipaddr);
    free(subject);
    vector_delete(data.extra_hdrs);
    return ret;
}
