#ifndef _SCANCODES_H
#define _SCANCODES_H

#include <term_internal.h>

#define US_MAP		0

#define SC_SHIFT_DOWN		"\xa9"
#define SC_SHIFT_UP		"\x29"
#define SC_CTRL_DOWN		"\xb6"
#define SC_CTRL_UP		"\x36"
#define SC_ALT_DOWN		"\xb7"
#define SC_ALT_UP		"\x37"
#define SC_TERMINATOR		"\xff"

#define SC_CURSOR_UP		"\xd1\x51\xff"
#define SC_CURSOR_DOWN		"\xd3\x53\xff"
#define SC_CURSOR_RIGHT		"\xd4\x54\xff"
#define SC_CURSOR_LEFT		"\xd2\x52\xff"
#define SC_INSERT		"\xcb\x4b\xff"
#define SC_DELETE		"\xce\x4e\xff"
#define SC_HOME			"\xcc\x4c\xff"
#define SC_END			"\xcf\x4f\xff"
#define SC_PAGE_UP		"\xcd\x4d\xff"
#define SC_PAGE_DOWN		"\xd0\x50\xff"

#define SC_FUNC_1		"\xbc\x3c\xff"
#define SC_FUNC_2		"\xbd\x3d\xff"
#define SC_FUNC_3		"\xbe\x3e\xff"
#define SC_FUNC_4		"\xbf\x3f\xff"
#define SC_FUNC_5		"\xc0\x40\xff"
#define SC_FUNC_6		"\xc1\x41\xff"
#define SC_FUNC_7		"\xc2\x42\xff"
#define SC_FUNC_8		"\xc3\x43\xff"
#define SC_FUNC_9		"\xc4\x44\xff"
#define SC_FUNC_10		"\xc5\x45\xff"
#define SC_FUNC_11		"\xc6\x46\xff"
#define SC_FUNC_12		"\xc7\x47\xff"

#define SC_SHIFT_FUNC_1		"\xa9\xbc\x3c\x29\xff"
#define SC_SHIFT_FUNC_2		"\xa9\xbd\x3d\x29\xff"
#define SC_SHIFT_FUNC_3		"\xa9\xbe\x3e\x29\xff"
#define SC_SHIFT_FUNC_4		"\xa9\xbf\x3f\x29\xff"
#define SC_SHIFT_FUNC_5		"\xa9\xc0\x40\x29\xff"
#define SC_SHIFT_FUNC_6		"\xa9\xc1\x41\x29\xff"
#define SC_SHIFT_FUNC_7		"\xa9\xc2\x42\x29\xff"
#define SC_SHIFT_FUNC_8		"\xa9\xc3\x43\x29\xff"
#define SC_SHIFT_FUNC_9		"\xa9\xc4\x44\x29\xff"
#define SC_SHIFT_FUNC_10	"\xa9\xc5\x45\x29\xff"
#define SC_SHIFT_FUNC_11	"\xa9\xc6\x46\x29\xff"
#define SC_SHIFT_FUNC_12	"\xa9\xc7\x47\x29\xff"

extern const unsigned char * asc2key(term_cl_t * clp, unsigned int c);

#endif /* _SCANCODES_H */
