#include <term_internal.h>

ssize_t
net_read(term_cl_t * clp, void * buf, size_t len, int no_timeout)
{
    ssize_t n;

    if (buf == NULL) return -1;

    while (1) {
	if ((n = read(clp->net_fd, buf, len)) > 0) {
	    return n;
	} else if (n == 0) {
	    pp_log("%s(): client gone\n", ___F);
	    return -1;
	} else if (errno == EAGAIN) {
	    if (no_timeout) continue;
	    pp_log("%s(): client timed out\n", ___F);
	    return -1;
	} else if (errno != EINTR) {
	    pp_log_err("%s(): read() failed", ___F);
	    return -1;
	}
    }
}

ssize_t
net_write(term_cl_t * clp, const void * buf, size_t len, int no_timeout)
{
    ssize_t n;

    if (buf == NULL) return -1;

    while (1) {
	if ((n = write(clp->net_fd, buf, len)) > 0) {
	    return n;
	} else if (n == 0 || errno == EPIPE) {
	    pp_log("%s(): client gone\n", ___F);
	    return -1;
	} else if (errno == EAGAIN) {
	    if (no_timeout) continue;
	    pp_log("%s(): client timed out\n", ___F);
	    return -1;
	} else if (errno != EINTR) {
	    pp_log_err("%s(): write() failed", ___F);
	    return -1;
	}
    }
}

int
eric_term_printf(term_cl_t * clp, const char * fmt, ...)
{
    char buf[1024];
    va_list args;
    int ret;

    va_start(args, fmt);
    ret = vsnprintf(buf, sizeof(buf), fmt, args);
    va_end(args);
    if (net_write(clp, buf, strlen(buf), 0) < 0) pthread_exit(NULL);
    return ret;
}
