/* 
 *	ej.h -- Ejscript(TM) header
 *
 * Copyright (c) GoAhead Software Inc., 1992-2000. All Rights Reserved.
 *
 *	See the file "license.txt" for information on usage and redistribution
 */

#ifndef _EJ_H
#define _EJ_H 1

/******************************* Description *********************************/

/* 
 * GoAhead Ejscript(TM) header. This defines the Ejscript API and internal
 * structures.
 */

/******************************** Includes ***********************************/

#include "uemf.h"
#include "webs.h"

/******************************* Prototypes **********************************/

int	ejArgs(int argc, char **argv, const char *fmt, ...);
void	ejSetResult(int eid, const char *s);
int	ejOpenEngine(sym_fd_t variables, sym_fd_t functions,webs_t wp);
void	ejCloseEngine(int eid);
int 	ejSetGlobalFunction(int eid, const char *name, 
				    int (*fn)(int eid, void *handle,
					      int argc, char **argv));
void	ejSetVar(int eid, const char *var, const char *value);
int	ejGetVar(int eid, const char *var, const char **value);
char	*ejEval(int eid, char *script, char **emsg);

#endif /* _EJ_H */
