#include <sys/types.h>
#include <regex.h>
#include <pp/intl.h>
#include <pp/cfg.h>
#include "eric_base.h"
#include "eric_validate.h"
#include "eric_util.h"

static int
validate_form_value(const pp_cd_as_type_t * realtype, int allow_empty,
		    const char * value, pp_cd_validation_error_t * val_err,
		    int * val_err_param)
{
    if (allow_empty && (value == NULL || *value == '\0')) return 1;
    return pp_cd_type_validate_value(realtype, value, val_err, val_err_param);
}
	
int
validate_form_var(webs_t wp, form_var_t * fv)
{
    int i, ret = 1;
    pp_cd_validation_error_t val_err;
    int val_err_param;
    
    assert(fv);
    
    /* don't validate disabled vars */
    if (form_var_is_disabled(wp, fv)) {
	return ret;
    }

    if (PP_CD_TYPE_IS_VECTOR_TEMPL(fv->realtype)) {
	for (i = 0; i < fv->val_cnt; i++) {
	    if(!(ret = validate_form_value(fv->elemtype,
					   fv->flags & FV_FLAG_ALLOW_EMPTY,
					   fv->val.m[i],
					   &val_err, &val_err_param))) {
		char label[MAX_LABEL_LEN + 1];
		snprintf(label, sizeof(label), "%s %d",
			 fv->label ? pp_intl_translate(fv->label) : NULL, i + 1);
		set_response(wp, ERIC_RESPONSE_ERROR, pp_intl_translate(pp_cd_val_err_msg(val_err)),
			     label, val_err_param);
		break;
	    }
	}
    } else {
	if (!(ret = validate_form_value(fv->realtype,
					fv->flags & FV_FLAG_ALLOW_EMPTY,
					fv->val.s,
					&val_err, &val_err_param))) {
	    set_response(wp, ERIC_RESPONSE_ERROR, pp_cd_val_err_msg(val_err),
			 fv->label ? pp_intl_translate(fv->label) : NULL, val_err_param);
	}
    }
    return ret;
}
