#ifndef _LIBERIC_WEBS_H
#define _LIBERIC_WEBS_H

#include <openssl/ssl.h>
#include <liberic_net.h>
#include <liberic_session.h>
#include <pp/intl.h>

typedef struct _eric_webs_session_data_t eric_webs_session_data_t;

/**
 * encoder descriptor
 *
 * Defines the callbacks that an forensic encoder has to
 * implement to connect to the webs library. Callbacks in
 * this structure may be NULL.
 */
typedef struct {
    /**
     * A wrong user login has occurred
     * 
     * @param user          The name of the user
     * @param ip            The IP address of the user
     */
    void (*encoder_login_failure)(const char * user, const char * ip_str);
} eric_webs_encoder_desc_t;

int eric_webs_connect_encoder(eric_webs_encoder_desc_t* encoder);

int eric_webs_init(void);
void eric_webs_cleanup(void);

eric_webs_session_data_t * eric_webs_alloc_session_data(void);
void eric_webs_free_session_data(void * _s);
void eric_webs_session_close_cb(eric_session_int_id_t sid);

void eric_webs_handle_connection(pp_net_conn_data_t * conn_data);

/* weak symbol for dyndns change handler */
void eric_webs_encode64(char *outbuf, const char *s, int outlen);

void eric_webs_ipmi_sdr_list_start(void);
void eric_webs_ipmi_sel_list_start(void);

#endif /* _LIBERIC_WEBS_H */
