/*
 * mime.c -- Web server mime types
 *
 * Copyright (c) GoAhead Software Inc., 1995-2000. All Rights Reserved.
 *
 * See the file "license.txt" for usage and redistribution license requirements
 */

/******************************* Description *********************************/

/*
 * Mime types and file extensions. This module maps URL extensions to
 * content types.
 */

/******************************** Includes ***********************************/

#include "wsIntrn.h"

/******************************* Global Data *********************************/

/*
 * Add entries to the MimeList as required for your content
 */

websMimeType websMimeList[] = {
    { "application/octet-stream", ".mib" },
    { "application/java", ".class" },
    { "application/java", ".jar" },
    { "text/html", ".asp" },
    { "text/html", ".htm" },
    { "text/html", ".html" },
    { "image/gif", ".gif" },
    { "image/png", ".png" },
    { "image/jpeg", ".jpg" },
    { "text/css", ".css" },
    { "text/plain", ".txt" },
    { NULL, NULL},
};
