/*
 * Page.c -- Support for page retrieval.
 *
 * Copyright (c) GoAhead Software Inc., 1995-2000. All Rights Reserved.
 *
 * See the file "license.txt" for usage and redistribution license requirements
 */

/******************************* Description *********************************/

/*
 * This module provides page retrieval handling. It provides support for
 * reading web pages from file systems and has expansion for ROMed web
 * pages.
 */

/******************************** Includes ***********************************/

#include "wsIntrn.h"

/********************************** Code *************************************/

/*
 * Open a web page. lpath is the local filename. path is the URL path name.
 */

int
websPageOpen(webs_t wp, char *lpath, char *path UNUSED, int mode, int perm)
{
    a_assert(wp);

    return (wp->docfd = open(lpath, mode, perm));
}

/*
 * Close a web page
 */

void
websPageClose(webs_t wp)
{
    a_assert(wp);

    if (wp->docfd >= 0) {
	close(wp->docfd);
	wp->docfd = -1;
    }
}

/*
 * Stat a web page lpath is the local filename. path is the URL path name.
 */

int
websPageStat(webs_t wp UNUSED, char *lpath, char *path UNUSED,
	     websStatType* sbuf)
{
    struct stat	s;

    if (stat(lpath, &s) < 0) {
	return -1;
    }
    sbuf->size = s.st_size;
    sbuf->mtime = s.st_mtime;
    sbuf->isDir = s.st_mode & S_IFDIR;
    return 0;
}

/*
 * Is this file a directory?
 */

int
websPageIsDirectory(char *lpath)
{
    struct stat sbuf;

    if (stat(lpath, &sbuf) >= 0) {
	return(sbuf.st_mode & S_IFDIR);
    } else {
	return 0;
    }
}

/*
 * Read a web page. Returns the number of _bytes_ read.
 * len is the size of buf, in bytes.
 */

int
websPageReadData(webs_t wp, char *buf, int nBytes)
{
    a_assert(wp);
    return read(wp->docfd, buf, nBytes);
}

/*
 * Move file pointer offset bytes.
 */

void
websPageSeek(webs_t wp, long offset)
{
    a_assert(wp);

    lseek(wp->docfd, offset, SEEK_CUR);
}
