#include <liberic_misc.h>
#include "tmpl_acl_common.h"
#include "eric_forms.h"
#include "wsIntrn.h"
#include <pp/acl.h>
#include <liberic_config.h>
#include <pp/um.h>
#include <pp/xdefs.h>
#include <pp/intl.h>
#if defined(PRODUCT_KX2)
#include <pp/hal_common.h>
#endif /* PRODUCT_KX2 */

static int acl_has_permission_asp(int eid, webs_t wp, int argc, char ** argv);
#ifdef PP_FEAT_PERM_MANAGEMENT
static int acl_init_all_objects_asp(int eid, webs_t wp, int argc, char ** argv);
static int acl_get_long_object_name_asp(int eid, webs_t wp,
                                        int argc, char ** argv);
static int acl_init_all_object_perms_asp(int eid, webs_t wp, 
                                         int argc, char ** argv);
static int acl_get_read_only_flag_asp(int eid, webs_t wp UNUSED, int argc, char ** argv);

static const char * perm_names[] = {
    N_("Yes"), N_("No"), 
    N_("None"), N_("View"), N_("Control"), 
    N_("No Access"), N_("Callback"), N_("User"), N_("Operator"), N_("Administrator"), N_("OEM"), 
    N_("Deny"), N_("Read-Only"), N_("Read-Write")
};

static const char * perm_values[] = {
    "yes", "no", 
    "none", "view", "control", 
    "NO_ACCESS", "CALLBACK", "USER", "OPERATOR", "ADMINISTRATOR", "OEM", 
    "deny", "readonly", "readwrite"
};

static const char * color_names[] = {
    "aclcoloryes", "aclcolorno", 
    "aclcolornone", "aclcolorview", "aclcolorcontrol", 
    "aclcolorna", "aclcolorcb", "aclcoloruser", "aclcolorop", "aclcoloradmin", "aclcoloroem", 
    "aclcolordeny", "aclcolorreadonly", "aclcolorreadwrite"
};

#endif /* PP_FEAT_PERM_MANAGEMENT */

#define ACL_YES_IDX     0
#define ACL_NO_IDX      1
#define ACL_NONE_IDX    2
#define ACL_VIEW_IDX    3
#define ACL_CONTROL_IDX 4
#define ACL_N_A_IDX     5
#define ACL_CB_IDX      6
#define ACL_USER_IDX    7
#define ACL_OP_IDX      8
#define ACL_ADMIN_IDX   9
#define ACL_OEM_IDX     10
#define ACL_DENY_IDX    11
#define ACL_RO_IDX      12
#define ACL_RW_IDX      13
#define ACL_YES_STR     perm_values[ACL_YES_IDX]
#define ACL_NO_STR      perm_values[ACL_NO_IDX]
#define ACL_NONE_STR    perm_values[ACL_NONE_IDX]
#define ACL_VIEW_STR    perm_values[ACL_VIEW_IDX]
#define ACL_CONTROL_STR perm_values[ACL_CONTROL_IDX]
#define ACL_N_A_STR     perm_values[ACL_N_A_IDX]
#define ACL_CB_STR      perm_values[ACL_CB_IDX]
#define ACL_USER_STR    perm_values[ACL_USER_IDX]
#define ACL_OP_STR      perm_values[ACL_OP_IDX]
#define ACL_ADMIN_STR   perm_values[ACL_ADMIN_IDX]
#define ACL_OEM_STR     perm_values[ACL_OEM_IDX]
#define ACL_DENY_STR    perm_values[ACL_DENY_IDX]
#define ACL_RO_STR      perm_values[ACL_RO_IDX]
#define ACL_RW_STR      perm_values[ACL_RW_IDX]

int
acl_common_tmpl_init(void)
{
    static int initialized = 0;

    if (!initialized) {
        /* register ASPs */
        websAspDefine("aclHasPermission", acl_has_permission_asp);
#ifdef PP_FEAT_PERM_MANAGEMENT
        websAspDefine("aclInitAllObjects", acl_init_all_objects_asp);
        websAspDefine("aclGetLongObjectName", acl_get_long_object_name_asp);
        websAspDefine("aclInitAllObjectPerms", acl_init_all_object_perms_asp);
	websAspDefine("aclGetReadOnlyFlag", acl_get_read_only_flag_asp);
#endif

        initialized = 1;
    }
    
    return 0;
}

/**
 * asp functions for acl related pages
 */

static int
acl_has_permission_asp(int eid, webs_t wp, int argc, char ** argv)
{
    const char * r = "no";

    if (argc == 2 &&
	PP_SUC == pp_um_user_has_permission(wp->user, argv[0], argv[1])) {
	r = "yes";
    }

    if (argc == 3 &&
	PP_SUC == pp_um_user_has_permission(argv[0], argv[1], argv[2])) {
	r = "yes";
    }
    
    ejSetResult(eid, r);

    return 0;
}

#if defined(PRODUCT_XX01IP_ANY) || defined(PP_FEAT_EXTENDED_PORT_ACLS)
static int
compare_ports_by_nr(const pp_acl_object_entry_t* x,
		    const pp_acl_object_entry_t* y)
{
    int ret = 0;
    
    assert(x && y);

    if (x->name && y->name) {
	int port_x, port_y;

	if (sscanf(x->name, "access_port_%d", &port_x) != 1 ||
	    sscanf(y->name, "access_port_%d", &port_y) != 1) {

	    goto bail;
	}

	if (port_x == port_y) ret = 0;
	else ret = (port_x > port_y) ? 1 : -1;
	
    }

 bail:
    return ret;
}
#endif /* PRODUCT_XX01IP_ANY || PP_FEAT_EXTENDED_PORT_ACLS */

#if defined(PP_FEAT_EXTENDED_PORT_ACLS)
static int
compare_vm_by_nr(const pp_acl_object_entry_t* x,
		    const pp_acl_object_entry_t* y)
{
    int ret = 0;
    
    assert(x && y);

    if (x->name && y->name) {
	int port_x, port_y;

	if (sscanf(x->name, "access_vm_%d", &port_x) != 1 ||
	    sscanf(y->name, "access_vm_%d", &port_y) != 1) {

	    goto bail;
	}

	if (port_x == port_y) ret = 0;
	else ret = (port_x > port_y) ? 1 : -1;
	
    }

 bail:
    return ret;
}
#endif /* PP_FEAT_EXTENDED_PORT_ACLS */

#ifdef PP_FEAT_PERM_MANAGEMENT
static int
acl_init_all_objects_asp(int eid UNUSED, webs_t wp, int argc,
			 char ** argv)
{
    vector_t *objects;
    char opt_name[MAX_OPT_KEY_LEN + 1];
    char cnt_opt_val[11];
    char *filter_incl = NULL, *filter_excl = NULL;
    pp_acl_custom_compare_cb_t custom_compare_cb = NULL;
    u_int i = 0, objects_sz, fv_id = FV_ID_ACL_PRINCIPAL_OBJECTS;
    form_handler_t *fh = lookup_form_handler(TEMPLATE_ACL);

#if defined(PP_FEAT_RARITAN_STYLE_UM_PAGES)
    websSetVar(wp, "__target_group__", wp->target_group);
#endif /* PP_FEAT_RARITAN_STYLE_UM_PAGES */

    /* fallthrough intended */
    switch (argc) {
      case 3:
#if defined(PRODUCT_XX01IP_ANY)
	  if (argv[2] && !strcmp(argv[2], "port")) {
	      custom_compare_cb = compare_ports_by_nr;
              fh = lookup_form_handler(TEMPLATE_ACL_PORTS);
              fv_id = FV_ID_ACL_PORTS_PRINCIPAL_OBJECTS;
	  }
#endif /* PRODUCT_XX01IP_ANY */
#if defined(PP_FEAT_EXTENDED_PORT_ACLS)
	  if (argv[2] && !strcmp(argv[2], "port")) {
	      custom_compare_cb = compare_ports_by_nr;
              fh = lookup_form_handler(TEMPLATE_ACL_XPORTS);
              fv_id = FV_ID_ACL_XPORTS_PRINCIPAL_OBJECTS_PORT;
	  }
	  if (argv[2] && !strcmp(argv[2], "vm")) {
	      custom_compare_cb = compare_vm_by_nr;
              fh = lookup_form_handler(TEMPLATE_ACL_XPORTS);
              fv_id = FV_ID_ACL_XPORTS_PRINCIPAL_OBJECTS_VM;
	  }
#endif /* PP_FEAT_EXTENDED_PORT_ACLS */
#ifdef PP_FEAT_PDU
	  if (argv[2] && !strcmp(argv[2], "outlet")) {
	      fh = lookup_form_handler(TEMPLATE_ACL_OUTLETS);
	      fv_id = FV_ID_ACL_OUTLETS_PRINCIPAL_OBJECTS;
	  }
#endif /* PP_FEAT_PDU */
      case 2:
	  filter_excl = (char*)argv[1];
      case 1:
	  filter_incl = (char*)argv[0];
      default:
	  break;
    }

    objects = pp_acl_objects_get_all_custom_compare(filter_incl, filter_excl,
						    custom_compare_cb);
    objects_sz = vector_size(objects);
#if defined(PRODUCT_KX2)
    if ((custom_compare_cb == compare_ports_by_nr) || 
        (custom_compare_cb == compare_vm_by_nr)) {
        objects_sz = pp_hal_common_get_target_port_cnt();
    }
#endif /* PRODUCT_KX2 */
    
    for (i = 0; i < objects_sz; ++i) {
        form_var_vec_name(fh->fv_tmpl[fv_id].fvname, i, 
                          opt_name, sizeof(opt_name));
	websSetVar(wp, opt_name, (char*)vector_get(objects, i));
    }
    vector_delete(objects);

    form_var_sz_name(fh->fv_tmpl[fv_id].fvname, opt_name, sizeof(opt_name));
    snprintf(cnt_opt_val, sizeof(cnt_opt_val), "%u", i);
    websSetVar(wp, opt_name, cnt_opt_val);

    return 0;
}

static int
acl_get_long_object_name_asp(int eid, webs_t wp UNUSED, int argc, char ** argv)
{
    const char * r;

    r = (argc == 1) ? pp_acl_objects_get_long_name(argv[0]) : NULL;
    ejSetResult(eid, r);
    return 0;
}

static int
acl_get_read_only_flag_asp(int eid, webs_t wp, int argc, char ** argv)
{
    const char * r = "no";

#if defined(PP_FEAT_IPMI_SERVER) && !defined(PP_FEAT_BMC_OEMCMDS_ONLY)
    if (argc == 1) {
        char *priv_level = NULL;
        
        /* if priv_level set (!=NO_ACCESS), get read only flag for permission */        
        if(PP_ERR != pp_um_group_get_permission(wp->target_group, "ipmi_priv",
                                                &priv_level) &&
           strcmp(priv_level, PP_CD_IPMIPRIVLEVEL_NO_ACCESS_STR)) {
   	   r = pp_acl_objects_get_read_only_flag(argv[0]);
        }
    }    
#else /* !PP_FEAT_IPMI_SERVER || PP_FEAT_BMC_OEMCMDS_ONLY */
    (void)wp;
    (void)argc;
    (void)argv;
#endif /* !PP_FEAT_IPMI_SERVER || PP_FEAT_BMC_OEMCMDS_ONLY */

    ejSetResult(eid, r);
    return 0;
}

int
get_raasip_permission(const webs_t wp, const char *group, const char *perm) {
    int perm_idx = -1;
    unsigned int perm_cnt = 0, i;
    char *type;
    unsigned int all_perms[6];
    char buf[MAX_OPT_KEY_LEN + 1];
    
    if(PP_ERR != pp_acl_objects_get_type(&type, perm)) {
        if(!strcmp(type, PP_CD_PERMTYPE_ADMIN_STR) || 
           !strcmp(type, PP_CD_PERMTYPE_USER_STR)) {
            /* user or admin perm, defaults to "no" */
            perm_idx = ACL_NO_IDX;
            if(group &&
               PP_SUC == pp_um_group_has_permission(group, perm, ACL_YES_STR)) {
                perm_idx = ACL_YES_IDX;
            }
            all_perms[perm_cnt++] = ACL_YES_IDX;
            all_perms[perm_cnt++] = ACL_NO_IDX;
#if defined(PRODUCT_XX01IP_ANY) || defined(PP_FEAT_EXTENDED_PORT_ACLS)
        } else if(!strcmp(type, PP_CD_PERMTYPE_PORT_STR)) {
            /* port perm, defaults to "none" */
            perm_idx = ACL_NONE_IDX;
            /* check at first for control, then for view! (admin has all!) */
            if(group &&
               PP_SUC == pp_um_group_has_permission(group, perm, 
                                                    ACL_CONTROL_STR)) {
                perm_idx = ACL_CONTROL_IDX;
            } else if(group &&
                      PP_SUC == pp_um_group_has_permission(group, perm,
                                                           ACL_VIEW_STR)) {
                perm_idx = ACL_VIEW_IDX;
            }
            all_perms[perm_cnt++] = ACL_NONE_IDX; 
            all_perms[perm_cnt++] = ACL_VIEW_IDX; 
            all_perms[perm_cnt++] = ACL_CONTROL_IDX; 
#endif /* PRODUCT_XX01IP_ANY || PP_FEAT_EXTENDED_PORT_ACLS */
#if defined(PP_FEAT_EXTENDED_PORT_ACLS)
        } else if(!strcmp(type, PP_CD_PERMTYPE_VM_STR)) {
            /* vm perm, defaults to "deny" */
            perm_idx = ACL_NONE_IDX;
            /* check at first for readwrite, then for readonly! (admin has all!) */
            if(group &&
               PP_SUC == pp_um_group_has_permission(group, perm, 
                                                    ACL_RW_STR)) {
                perm_idx = ACL_RW_IDX;
            } else if(group &&
                      PP_SUC == pp_um_group_has_permission(group, perm,
                                                           ACL_RO_STR)) {
                perm_idx = ACL_RO_IDX;
            }
            all_perms[perm_cnt++] = ACL_DENY_IDX; 
            all_perms[perm_cnt++] = ACL_RO_IDX; 
            all_perms[perm_cnt++] = ACL_RW_IDX; 
#endif /* PP_FEAT_EXTENDED_PORT_ACLS */
#ifdef PP_FEAT_IPMI_SERVER
        } else if(!strcmp(type, PP_CD_PERMTYPE_PRIVLVL_STR)) {
            /* IPMI Privilege Level */
            
            /* test for all privilege levels. admin is last */
            int ipmi_indices[] = { ACL_CB_IDX, ACL_USER_IDX, ACL_OP_IDX,
                                   ACL_OEM_IDX, ACL_ADMIN_IDX };
                                   
            /* defaults to "NO_ACCESS" */
            perm_idx = ACL_N_A_IDX;
            all_perms[perm_cnt++] = ACL_N_A_IDX; 

            if(group) {
                for(i = 0; i < sizeof(ipmi_indices) / sizeof(int); ++i) {
                    all_perms[perm_cnt++] = ipmi_indices[i]; 
                    if(PP_SUC == pp_um_group_has_permission(group, perm,
                                                perm_values[ipmi_indices[i]])) {
                        perm_idx = ipmi_indices[i];
                    }
                }
            }
#endif /* PP_FEAT_IPMI_SERVER */
        } else {
            /* should not happen */
            pp_log("invalid permission type %s\n", type);
            assert(0);
        }
        free(type);
    }
    
    for (i = 0; i < perm_cnt; ++i) {
        form_var_vec_name("all_perms", i, buf, sizeof(buf));
	websSetVar(wp, buf, perm_names[all_perms[i]]);
        form_var_vec_name("all_perms_value", i, buf, sizeof(buf));
	websSetVar(wp, buf, perm_values[all_perms[i]]);
        form_var_vec_name("all_perms_color", i, buf, sizeof(buf));
	websSetVar(wp, buf, color_names[all_perms[i]]);
    }

    snprintf(buf, sizeof(buf), "%u", perm_cnt);
    websSetVar(wp, "all_perms_cnt", buf);

    return perm_idx;
}                                 

static int
acl_init_all_object_perms_asp(int eid UNUSED, webs_t wp, int argc, char ** argv)
{
    /* perhaps we should do this more generic, but for current RAASIP spec, it
       will work */
    int perm_idx;
       
    if (argc == 1 && 
        PP_ERR != (perm_idx = get_raasip_permission(wp, wp->target_group, 
                                                    argv[0]))) {
        form_handler_t *fh = lookup_form_handler(TEMPLATE_ACL);
        char opt_name[MAX_OPT_KEY_LEN + 1];
    
        form_var_assoc_name(fh->fv_tmpl[FV_ID_ACL_PRINCIPAL_ACL].fvname,
                            argv[0], opt_name, sizeof(opt_name));
        if(!wp->target_gid) {
            /* admin group or value not set */
            websSetVar(wp, opt_name, perm_names[perm_idx]);
        }
	websSetVar(wp, "p_object_color", color_names[perm_idx]);
    }
    
    return 0;
}
#endif /* PP_FEAT_PERM_MANAGEMENT */
