#include <liberic_net.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"

FV_SPEC = {
    {
	id:		FV_ID_AUTH_LDAP_USER_HOST,
	cfgkey:		"ldap.host",
    },
    {
	id:		FV_ID_AUTH_LDAP_SSL,
	cfgkey:		"ldap.ssl.enabled",
    },
    {
	id:		FV_ID_AUTH_LDAP_PORT,
	cfgkey:		"ldap.port",
    },
    {
	id:		FV_ID_AUTH_LDAP_SSL_PORT,
	cfgkey:		"ldap.ssl.port",
    },
    {
	id:		FV_ID_AUTH_LDAP_USER_BASE_DN,
	cfgkey:		"ldap.base_dn",
    },
#if defined(PP_FEAT_RARITAN_STYLE_LDAP_SETTINGS)
    {
	id:		FV_ID_AUTH_LDAP_SECRET,
	cfgkey:		"ldap.secret",
    },
    {
	id:		FV_ID_AUTH_LDAP_USER_BASE_SEARCH,
	cfgkey:		"ldap.base_search",
    },
#else /* PP_FEAT_RARITAN_STYLE_LDAP_SETTINGS */
    {
	id:		FV_ID_AUTH_LDAP_LOGIN_ATTR_TYPE,
	cfgkey:		"ldap.login_attrtype",
    },
    {
	id:		FV_ID_AUTH_LDAP_USER_OBJECTCLASS,
	cfgkey:		"ldap.user_objectclass",
    },
    {
	id:		FV_ID_AUTH_LDAP_USER_SEARCH_SUBFILTER,
	cfgkey:		"ldap.user_search_subfilter",
    },
#endif /* PP_FEAT_RARITAN_STYLE_LDAP_SETTINGS */
    {
	id:		FV_ID_AUTH_LDAP_USER_SERVER_TYPE,
	cfgkey:		"ldap.server_type",
    },
    {
	id:		FV_ID_AUTH_LDAP_ADS_DOMAIN_NAME,
	cfgkey:		"ldap.ads_domain_name",
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
auth_ldap_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_AUTH_LDAP, ACL_OBJ_AUTHOPT);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp, form_handler_t * fh)
{
    char *mode = get_form_var_value_unsaved(wp, TEMPLATE_AUTH, FV_ID_AUTH_MODE);
    if (pp_strcmp_safe(mode, "ldap")) {
        fh_disable_validate_and_save(fh, -1);
    }
    free(mode);

    if (strcmp(fh->fv[FV_ID_AUTH_LDAP_SSL].val.s, "yes")) {
        /* validate port only */
	fh->fv[FV_ID_AUTH_LDAP_SSL_PORT].flags |= FV_FLAG_SKIP_VALIDATE |
                                                  FV_FLAG_DONT_SAVE;
    } else {
        /* validate SSL port only */
	fh->fv[FV_ID_AUTH_LDAP_PORT].flags |= FV_FLAG_SKIP_VALIDATE |
                                              FV_FLAG_DONT_SAVE;
    }

    if (strcmp(fh->fv[FV_ID_AUTH_LDAP_USER_SERVER_TYPE].val.s, "ads")) {
	fh->fv[FV_ID_AUTH_LDAP_ADS_DOMAIN_NAME].flags |=
	    FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
    }
    
    return 0;
}
