#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

FV_SPEC = {};

#define DEBUG_BUFFER_SIZE       4096

static int init_debug_memory_vars_asp(int eid, webs_t wp, int argc, char **argv);
static void output_debug_file(webs_t wp, const char *file, const char *var);

static char debug_buffer[DEBUG_BUFFER_SIZE];

int
debug_memory_tmpl_init(void)
{
    form_handler_t * fh;
    
    /* register ASPs */
    websAspDefine("initDebugMemoryVars", init_debug_memory_vars_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_DEBUG_MEMORY, ACL_OBJ_SUPER);

    REGISTER_FH_INSTANCE_AND_RETURN(fh);   
    
    return 0;
}


static int
init_debug_memory_vars_asp(int eid UNUSED, webs_t wp, int argc UNUSED, char **argv UNUSED)
{
    char pidfilename[128];
    
    /* generate memory/fs/process debug output */
    output_debug_file(wp, "/proc/meminfo", "mem_debug");
    if (pp_system("df > /tmp/df.out") != -1) {
	output_debug_file(wp, "/tmp/df.out", "fs_debug");
    }
    snprintf(pidfilename, 128, "/proc/%d/status", getpid());
    output_debug_file(wp, pidfilename, "process_debug");   

    return 0;
}

static void
output_debug_file(webs_t wp, const char *file, const char *var)
{
    FILE* dbgfile;
    char linebuf[128];
    char *bufptr;
    
    dbgfile = fopen(file, "r");
    if (dbgfile) {
	bufptr = debug_buffer;
	while( fgets( linebuf, 128, dbgfile ) != NULL &&
	       (bufptr - debug_buffer) < DEBUG_BUFFER_SIZE) {
	    strcpy(bufptr, linebuf);
	    bufptr += strlen(linebuf)-1;
	    strncpy(bufptr, "<BR>", 4);
	    bufptr += 4;
	}
	fclose(dbgfile);
	*bufptr = '\0';
	websSetVar(wp, var, debug_buffer);
    }    
}
