#include <liberic_misc.h>
#include "eric_util.h"
#include <pp/cfg.h>
#include <pp/hal_common.h>
#include "eric_forms.h"
#include "ej.h"
#include "wsIntrn.h"

static int get_device_prod_info_asp (int eid, webs_t wp, int argc, char **argv);

int
device_prod_info_tmpl_init(void)
{
    /* register ASPs */
    websAspDefine("get_device_prod_info", get_device_prod_info_asp);
    return 0;
}

static int
get_device_prod_info_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED)
{
    char _unique[512];
    int _error;
    int _allow;
    const char * _clear;
    char * _serial = NULL;
    char * _flashid;
    char * _mac;
    char * _rev;
    const char * _result = "";
   
    pp_cfg_is_enabled(&_allow, "allow_prod_info");
    
#ifdef LARA_KIMMSI
    // always enabled on MSI KIM to allow remote discovery
    _allow = 1;
#endif

    if (_allow) {
	_clear = websGetVar(wp, "clear", "");
	if (!strcmp(_clear, "yes")) {
	    _error = pp_cfg_set_enabled(0, "allow_prod_info");
	    if (_error) {
		ejSetResult(eid, "?0");
	    } else {
		_error = pp_cfg_save(DO_FLUSH);
		_result = _error ? "?1" : ".";
	    }
	} else {
	    pp_cfg_get_nodflt(&_serial, "serial");
	    _flashid = pp_hal_common_get_flash_factory_id();
	    pp_cfg_get(&_mac, "network.mac");
	    _rev = eric_misc_get_hardware_rev_str();
	    snprintf(_unique, sizeof(_unique), "%c%c.%c%c.%c%c;%s;%s;%s;%u;%s;%s",
		     pp_firmware_erla_version[0], pp_firmware_erla_version[1],
		     pp_firmware_erla_version[2], pp_firmware_erla_version[3],
		     pp_firmware_erla_version[4], pp_firmware_erla_version[5],
		     _serial, _flashid, _mac, pp_firmware_erla_build_nr, pp_firmware_erla_tag, _rev);
	    free(_serial);
	    free(_flashid);
	    free(_mac);
	    free(_rev);
	    _result = _unique;
	}
    }

    ejSetResult(eid, _result);

    return 0;
}
