#include <pp/firmware.h>
#include <liberic_misc.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "wsIntrn.h"
#include "tmpl_firmware_common.h"

#ifdef PP_FEAT_PDU
#include <pp/bmc/bmc.h>
#include <pp/bmc/host_sensors.h>
#include <pp/bmc/tp_rs485_chip.h>
static int get_relay_sw_ver_asp(int eid, webs_t wp, int argc, char **argv);
static int get_relay_hw_ver_asp(int eid, webs_t wp, int argc, char **argv);
#endif

static int get_fw_info_asp(int eid, webs_t wp, int argc, char **argv);

int
firmware_common_tmpl_init(void)
{
    static int initialized = 0;

    if (!initialized) {
	/* register ASPs */
	websAspDefine("getFWInfo", get_fw_info_asp);
#ifdef PP_FEAT_PDU
	websAspDefine("getRelaySWVer", get_relay_sw_ver_asp);
	websAspDefine("getRelayHWVer", get_relay_hw_ver_asp);
#endif	
	initialized = 1;
    }

    return 0;
}

static int
get_fw_info_asp(int eid, webs_t wp, int argc, char **argv)
{
    char buf[128];
    char * ver = NULL;
    char * tag = NULL;
    int bnr;

    buf[0] = '\0';

    if (argc == 2) {
	if (!strcmp(argv[0], "running")) {
	    ver = strdup(pp_firmware_erla_version);
	    tag = strdup(pp_firmware_erla_tag);
	    bnr = pp_firmware_erla_build_nr;
	} else if (!strcmp(argv[0], "uploaded")) {
#if defined(PRODUCT_FLASHX4)
	    char * fp_upload = websGetVar(wp, "flashprog_upload", "");
	    if (!strcmp(fp_upload, "yes")) goto bail;
#endif
	    if (PP_ERR == pp_firmware_erla_get_info(wp->sd->firmware_ctx,
						    &ver, &bnr, &tag, NULL, NULL)) {
		goto bail;
	    }
	} else {
	    goto bail;
	}
	if (!strcmp(argv[1], "version")) {
	    snprintf(buf, sizeof(buf), "%c%c.%c%c.%c%c",
		     ver[0], ver[1], ver[2], ver[3], ver[4], ver[5]);
	} else if (!strcmp(argv[1], "build_nr")) {
	    snprintf(buf, sizeof(buf), "%u", bnr);
	} else if (!strcmp(argv[1], "tag")) {
	    snprintf(buf, sizeof(buf), "%s", tag);
	} else if (!strcmp(argv[1], "all")) {
	    if (bnr == -1) {
		snprintf(buf, sizeof(buf), "%c%c.%c%c.%c%c",
			 ver[0], ver[1], ver[2], ver[3], ver[4], ver[5]);
	    } else {
		snprintf(buf, sizeof(buf), "%c%c.%c%c.%c%c (Build %u) / %s",
			 ver[0], ver[1], ver[2], ver[3], ver[4], ver[5],
			 bnr, tag);
	    }
	}
    }

 bail:
    ejSetResult(eid, buf);
    free(ver);
    free(tag);
    return 0;
}

#ifdef PP_FEAT_PDU

/* should better make rc_cy8c26.h public??? */
#define RC_CY8C26_DEVICE_ID              0x00
#define RC_CY8C26_FW_VERSION_ID          0x01
#define RC_CY8C26_HW_CFG_VERSION         0x02

static int rc_get_sw_ver(void* ctx) {
    pp_tp_rs485_chip_t* chip;
    unsigned char ver;
    if ((chip = pp_bmc_host_get_rs485_chip(PP_BMC_RS485_CHIP_RPC0)) != NULL) {
	pp_tp_rs485_chip_get_byte(chip, RC_CY8C26_FW_VERSION_ID, &ver);
	*(int*)ctx = ver;
    } else {
	*(int*)ctx = -1;
    }
    return PP_SUC;
}

static int rc_get_hw_ver(void* ctx) {
    pp_tp_rs485_chip_t* chip;
    unsigned char dev, rev;
    if ((chip = pp_bmc_host_get_rs485_chip(PP_BMC_RS485_CHIP_RPC0)) != NULL) {
	pp_tp_rs485_chip_get_byte(chip, RC_CY8C26_DEVICE_ID, &dev);
	pp_tp_rs485_chip_get_byte(chip, RC_CY8C26_HW_CFG_VERSION, &rev);
	*(int*)ctx = dev << 8 | rev;
    } else {
	*(int*)ctx = -1;
    }
    return PP_SUC;
}   

static int get_relay_sw_ver_asp(int eid, webs_t wp UNUSED,
				int argc UNUSED, char **argv UNUSED)  {
    char buf[] = "??  ";
    int ver;
    if (PP_SUC == pp_bmc_run_fkt(rc_get_sw_ver, &ver) && ver > 0) {
	snprintf(buf, sizeof(buf), "%#.2x", ver);
    }
    ejSetResult(eid, buf);
    return 0;
}

static int get_relay_hw_ver_asp(int eid, webs_t wp UNUSED,
				int argc UNUSED, char **argv UNUSED) {
    char buf[] = "?? : ??    ";
    int rev;
    if (PP_SUC == pp_bmc_run_fkt(rc_get_hw_ver, &rev) && rev > 0) {
	snprintf(buf, sizeof(buf), "0x%.2x : 0x%.2x", rev >> 8, rev & 0xff);
    }
    ejSetResult(eid, buf);
    return 0;
}

#endif	
