#include <liberic_config.h>
#include <pp/intl.h>
#include <pp/ipmi.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"
#include "templates.h"

FV_SPEC = {
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int ipmi_chassis_control_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_CHASSIS_CONTROL, ACL_OBJ_IPMI_STATUS);
    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

/* the formular handler (parses the buttons) */
static int pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    int cmd = -1;

    if (form_button_clicked(wp, "action_cancel_poweroff") ||
        form_button_clicked(wp, "action_cancel_poweron") ||
        form_button_clicked(wp, "action_cancel_powercycle") ||
        form_button_clicked(wp, "action_cancel_softshutdown") ||
        form_button_clicked(wp, "action_cancel_reset")) {
        
        set_response(wp, ERIC_RESPONSE_OK, _("Power Control via IPMI cancelled."));
        return 0;
    }

    if (form_button_clicked(wp, "action_poweroff")) {
        set_response(wp, ERIC_RESPONSE_OK, _("Press 'Really Power Down' if you really want to power down the computer!"));
        websSetVar(wp, "_show_poweroff_confirm", "1");
        return 0;
    } else if (form_button_clicked(wp, "action_poweron")) {
        set_response(wp, ERIC_RESPONSE_OK, _("Press 'Really Power Up' if you really want to power up the computer!"));
        websSetVar(wp, "_show_poweron_confirm", "1");
        return 0;
    } else if (form_button_clicked(wp, "action_powercycle")) {
        set_response(wp, ERIC_RESPONSE_OK, _("Press 'Really Power Cycle' if you really want to power cycle the computer!"));
        websSetVar(wp, "_show_powercycle_confirm", "1");
        return 0;
    } else if (form_button_clicked(wp, "action_softshutdown")) {
        set_response(wp, ERIC_RESPONSE_OK, _("Press 'Really Soft Shutdown' if you really want to shut down softly the computer!"));
        websSetVar(wp, "_show_softshutdown_confirm", "1");
        return 0;
    } else if (form_button_clicked(wp, "action_reset")) {
        set_response(wp, ERIC_RESPONSE_OK, _("Press 'Really Reset' if you really want to reset the computer!"));
        websSetVar(wp, "_show_reset_confirm", "1");
        return 0;
    }

    if (form_button_clicked(wp, "action_really_poweroff")) {
        cmd = PP_IPMI_CHASSIS_POWER_DOWN;
    } else if (form_button_clicked(wp, "action_really_poweron")) {
        cmd = PP_IPMI_CHASSIS_POWER_UP;
    } else if (form_button_clicked(wp, "action_really_powercycle")) {
        cmd = PP_IPMI_CHASSIS_POWER_CYCLE;
    } else if (form_button_clicked(wp, "action_really_softshutdown")) {
        cmd = PP_IPMI_CHASSIS_POWER_SOFT;
    } else if (form_button_clicked(wp, "action_really_reset")) {
        cmd = PP_IPMI_CHASSIS_RESET;
    }

    if (cmd != -1) {
        const char *err;
        pp_log("Executing Power Control.\n");
        if (ipmi_chassis_power_control(wp, cmd, &err)) {
            set_response(wp, ERIC_RESPONSE_ERROR, err);
        } else {
            set_response(wp, ERIC_RESPONSE_OK, _("Successfully executed Power Control."));
        }
    }

    return 0;
}

/* backend for the buttons */
int ipmi_chassis_power_control(webs_t wp, int command, const char **errstr) {
    pp_ipmi_return_t ipmi_ret;
    pp_ipmi_parameter_t ipmi_param;
    int ret, err;

    if (errstr) *errstr = "";
    memset(&ipmi_ret, 0, sizeof(ipmi_ret));
    memset(&ipmi_param, 0, sizeof(ipmi_param));
    ipmi_param.data.chassis_power = command;

    ret = pp_ipmi_send_command(PP_IPMI_CMD_CHASSIS, PP_IPMI_CHASSIS_SUBCMD_POWER_CONTROL, &ipmi_param, &ipmi_ret, &err, wp->user);
    if (ret) {
        if (errstr) *errstr = pp_ipmi_get_error_string(err);
        pp_log("Error in sending Power Control command (%s).\n", errstr ? *errstr : pp_ipmi_get_error_string(err));
    }

    pp_ipmi_cleanup_ret(&ipmi_ret);
    return ret;
}
