#include <liberic_config.h>
#include <pp/intl.h>
#include <pp/ipmi.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"
#include "templates.h"
#include "ej.h"

FV_SPEC = {
};


static int pre_validate_hook(webs_t wp, form_handler_t * fh);

#ifdef PRODUCT_AMDDC
static int get_local_lockout_state_asp(int eid, webs_t wp, int argc, char **argv);
#endif

int
ipmi_chassis_opma_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_CHASSIS_OPMA, ACL_OBJ_IPMI_STATUS);
    fh->pre_validate_hook = pre_validate_hook;

#ifdef PRODUCT_AMDDC
    websAspDefine("ipmiGetLocalLockoutState", get_local_lockout_state_asp);
#endif

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

/* the formular handler (parses the buttons) */
#ifdef PRODUCT_AMDDC
static int
pre_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    pp_ipmi_return_t ipmi_ret;
    pp_ipmi_parameter_t ipmi_param;
    int cmd = -1;

    memset(&ipmi_ret, 0, sizeof(ipmi_ret));
    memset(&ipmi_param, 0, sizeof(ipmi_param));
    
    if (form_button_clicked(wp, "action_lockouton")) {
        cmd = PP_IPMI_OEM_OPMA_SET_LOCAL_LOCKOUT;
	ipmi_param.data.oem_opma_set_local_lockout.lock = 1;
    } else if (form_button_clicked(wp, "action_lockoutoff")) {
        cmd = PP_IPMI_OEM_OPMA_SET_LOCAL_LOCKOUT;
	ipmi_param.data.oem_opma_set_local_lockout.lock = 0;
    } else if (form_button_clicked(wp, "action_clearcmos")) {
	cmd = PP_IPMI_OEM_OPMA_CLEAR_CMOS;
    }

    if (cmd != -1) {
	int err;

	if (pp_ipmi_send_command(PP_IPMI_CMD_OEM_OPMA, cmd, &ipmi_param, &ipmi_ret, &err, wp->user) == 0) {
            set_response(wp, ERIC_RESPONSE_OK, _("Operation completed successfully."));
	} else {
	    pp_log("Error in sending OPMA OEM command (%s).\n", pp_ipmi_get_error_string(err));
	    set_response(wp, ERIC_RESPONSE_ERROR, pp_ipmi_get_error_string(err));
	}
    }

    return 0;
}
#else
static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh UNUSED)
{
    return 0;
}
#endif

#ifdef PRODUCT_AMDDC
static int
get_local_lockout_state_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED)
{
    pp_ipmi_return_t ipmi_ret;
    pp_ipmi_parameter_t ipmi_param;
    int err;

    memset(&ipmi_ret, 0, sizeof(ipmi_ret));
    memset(&ipmi_param, 0, sizeof(ipmi_param));

    if (pp_ipmi_send_command(PP_IPMI_CMD_OEM_OPMA, PP_IPMI_OEM_OPMA_GET_LOCAL_LOCKOUT, &ipmi_param, &ipmi_ret, &err, wp->user) == 0) {
	if (ipmi_ret.data.oem_opma_get_local_lockout.locked) {
	    ejSetResult(eid, "Active");
	} else {
	    ejSetResult(eid, "Not active");
	}
    } else {
        pp_log("Error in sending OPMA OEM command (%s).\n", pp_ipmi_get_error_string(err));
	ejSetResult(eid, "Unknown");
    }
    
    pp_ipmi_cleanup_ret(&ipmi_ret);
    return 0;
}
#endif /* PRODUCT_AMDDC */
