#include "eric_base.h"

/**
 * Note: 
 * I know that the double casting (void*)((int)v) is crude and ugly, but I
 * know no other way to pass one parameter in a simple way and avoid compiler
 * warnings.
 */

/**
 * Prints a table head <th>STRING</th>
 */
void print_head(pp_strstream_t* tab, const unsigned char* str);

/**
 * Prints a table cell with one dynamic value, the format of
 * this value can be specified. This function is wrapped to
 * allow passing any value through void* without warning.
 */
#define print_cell(t, f, v) __print_cell(t, f, (void*)((int)(v)))
void __print_cell(pp_strstream_t* tab, const unsigned char* format, const void* value);

/**
 * Prints a name="xxx" for form input elements based on the elements numeric id.
 */
void print_fv(pp_strstream_t* tab, int fv_name, const char* template_name);

/**
 * Prints a form input element. 
 * @param tab      Output strstream
 * @param template_name  the name of the template
 * @param id       the numerical id of the element
 * @param type     the input type ("text" or "readonly")
 * @param format   input format ("%s", "%d" etc)
 * @param value    the value (usage like in printf)
 * @param size     the length of the input field
 * @param readonly whether the 'readonly' attribute is added
 */
#define print_input_cell(ta, id, tn, ty, fo, va, si, ro) __print_input_cell(ta, id, tn, ty, fo, ((void*)((int)va)), si, ro);
void __print_input_cell(pp_strstream_t* tab, int id, const char* template_name, 
                          const char* type, const char* format, void* value,
                          int size, int readonly);

/**
 * Prints a form input element in a table cell
 */
#define print_input(ta, id, tn, ty, fo, va, si, ro) __print_input(ta, id, tn, ty, fo, ((void*)((int)va)), si, ro);
void __print_input(pp_strstream_t* tab, int id, const char* template_name, 
                          const char* type, const char* format, void* value,
                          int size, int readonly);


