#include <liberic_config.h>
#include <pp/intl.h>
#include <pp/ipmi.h>
#include "ej.h"
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include "tmpl_ipmi_common.h"


/* internal prototypes */
static void display_filter_table(pp_strstream_t* tab, webs_t wp);
static void add_filter_table_head(pp_strstream_t *tab);
static void add_filter_table_entry(pp_strstream_t* tab, pp_ipmi_pef_filter_t* filter);
static int ipmi_build_filter_table_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED);


FV_SPEC = {
};


int ipmi_filter_list_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("ipmiGetFilterList", ipmi_build_filter_table_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_FILTER_LIST, ACL_OBJ_IPMI_STATUS);

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static void display_filter_table(pp_strstream_t* tab, webs_t wp) {
    vector_t* filters;
    unsigned int i;
    pp_ipmi_return_t ipmi_ret;
    
    /* read values from ipmi */
    memset(&ipmi_ret, 0, sizeof(ipmi_ret));
    if (!pp_ipmi_send_command(PP_IPMI_CMD_PEF, PP_IPMI_PEF_FILTER_GET, NULL, &ipmi_ret, NULL, wp->user)) {
        filters = ipmi_ret.data.pef_filter_list;
    } else {
        filters = NULL;
    }
#if !defined(PP_FEAT_RARITAN_DESIGN)    
    pp_strappend(tab, "<table border=\"1\">\n");
#else
    pp_strappend(tab, "<script>\n");    
#endif    
    add_filter_table_head(tab);
    if (filters != NULL) {
        for (i=0; i<vector_size(filters); i++) {
            add_filter_table_entry(tab, (pp_ipmi_pef_filter_t*)vector_get(filters, i));
        }
    } else {
#if !defined(PP_FEAT_RARITAN_DESIGN)    
	pp_strappend(tab, "<tr><td colspan=21>");
	pp_strappend(tab, _("Error reading the filters"));
	pp_strappend(tab, "</td></tr>\n");
#else
        pp_strappend(tab, "table_entry('");
        pp_strappend(tab, _("Error reading the filters"));
        pp_strappend(tab, "','','','','','','','','','','','','','','','','','','','','','');</script>\n");
#endif
    }
#if !defined(PP_FEAT_RARITAN_DESIGN)    
    pp_strappend(tab, "</table>\n");
#else
    pp_strappend(tab, "\n</script>\n");    
#endif    
    vector_delete(filters);
}

static void add_filter_table_head(pp_strstream_t *tab) {
#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "<tr>\n");
    pp_strappend(tab, "  <td class=\"bold\">Index</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Status</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Filter Type</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Action</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Policy#</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Severity</td>\n");
    pp_strappend(tab, "  <td class=\"bold\" colspan=2>Generator ID</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Sensor<br> Type</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Sensor<br> No</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Trigger</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Offset<br> Mask</td>\n");
    pp_strappend(tab, "  <td class=\"bold\" colspan=3>Data 1</td>\n");
    pp_strappend(tab, "  <td class=\"bold\" colspan=3>Data 2</td>\n");
    pp_strappend(tab, "  <td class=\"bold\" colspan=3>Data 3</td>\n");
    pp_strappend(tab, "  <td></td>\n");
    pp_strappend(tab, "</tr>\n");
#else /* PP_FEAT_RARITAN_DESIGN */
    (void)tab;
#endif /* PP_FEAT_RARITAN_DESIGN */
}

static void add_filter_table_entry(pp_strstream_t* tab, pp_ipmi_pef_filter_t* filter) {
    const unsigned char* bufp;
    unsigned short* usp;

#if !defined(PP_FEAT_RARITAN_DESIGN)    
    pp_strappend(tab, "<tr>\n");
#else
    pp_strappend(tab, "\n table_entry(");
#endif    

    print_cell(tab, "%d", filter->id);
    
    if (filter->enable == 1) {
        bufp = "enabled";
    } else {
        bufp = "disabled";
    }

    print_cell(tab, "%s", bufp);

    if (filter->configuration_type == 0) {
        bufp = "configurable";
    } else {
        bufp = "predefined";
    }

    
    print_cell(tab, "%s", bufp);

#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "<td class = \"normal\">");
#else
    pp_strappend(tab, "'");	
#endif
    if (filter->action.alert == 1)
        pp_strappend(tab, "<tt>alert</tt>&nbsp&nbsp");
    if (filter->action.poweroff == 1)
        pp_strappend(tab, "<tt>poweroff</tt>&nbsp&nbsp");
    if (filter->action.reset == 1)
        pp_strappend(tab, "<tt>reset</tt>&nbsp&nbsp");
    if (filter->action.power_cycle == 1)
        pp_strappend(tab, "<tt>power cycle</tt>&nbsp&nbsp");
#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "</td>");
#else
    pp_strappend(tab, "',");    
#endif

    print_cell(tab, "%d", filter->alert_policy_number);    

    bufp = "unspecified";
    if ((filter->event_severity & 0x01) != 0) {
        bufp = "monitor";
    }
    if ((filter->event_severity & 0x02) != 0) {
        bufp = "information";
    }
    if ((filter->event_severity & 0x04) != 0) {
        bufp = "ok";
    }
    if ((filter->event_severity & 0x08) != 0) {
        bufp = "non-critical";
    }
    if ((filter->event_severity & 0x10) != 0) {
        bufp = "critical";
    }
    if ((filter->event_severity & 0x20) != 0) {
        bufp = "non-recoverable";
    }

    print_cell(tab, "%s", bufp);

    print_cell(tab, "%.2x", filter->generatorID1);
    print_cell(tab, "%.2x", filter->generatorID2);

    print_cell(tab, "%.2x", filter->sensor_type);
    print_cell(tab, "%.2x", filter->sensor_number);
    print_cell(tab, "%.2x", filter->event_trigger);

    usp = (unsigned short*)(&(filter->offset_mask1));
    print_cell(tab, "%.4x", *usp);

    print_cell(tab, "%.2x", filter->data_filter[0].mask);
    print_cell(tab, "%.2x", filter->data_filter[0].exact);
    print_cell(tab, "%.2x", filter->data_filter[0].data);

    print_cell(tab, "%.2x", filter->data_filter[1].mask);
    print_cell(tab, "%.2x", filter->data_filter[1].exact);
    print_cell(tab, "%.2x", filter->data_filter[1].data);

    print_cell(tab, "%.2x", filter->data_filter[2].mask);
    print_cell(tab, "%.2x", filter->data_filter[2].exact);
    print_cell(tab, "%.2x", filter->data_filter[2].data);

#if !defined(PP_FEAT_RARITAN_DESIGN)        
    print_cell(tab, "<a href=\"ipmi_filter_edit.asp?filter=%d\">[edit]</a>", filter->id);
    pp_strappend(tab, "</tr>\n");
#else
    print_cell(tab, "<a href=\"ipmi_filter_edit.asp?filter=%d\">[edit]</a>'); //", filter->id);
#endif    
}

static int ipmi_build_filter_table_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED) {
    pp_strstream_t tab = PP_STRSTREAM_INITIALIZER;

    pp_strstream_init(&tab);

    display_filter_table(&tab, wp);

    ejSetResult(eid, tab.buf ? tab.buf : "");

    pp_strstream_free(&tab);

    return 0;
}






