#include <liberic_config.h>
#include <pp/intl.h>
#include <pp/ipmi.h>
#include "ej.h"
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include "tmpl_ipmi_common.h"


#define IPMI_ALERT_DEST_TYPE_PET        0x0
#define IPMI_ALERT_DEST_TYPE_EMAIL      0x6 /* Peppercon OEM */


/* internal prototypes */
static void display_destination_table(pp_strstream_t* tab, webs_t wp);
static void add_destination_table_head(pp_strstream_t *tab);
static void add_destination_table_entry(pp_strstream_t *tab, pp_ipmi_lanp_dest_list_entry_t *dest);
static int ipmi_build_lan_destination_table_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED);


FV_SPEC = {
};


int ipmi_lan_dest_list_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("ipmiGetLanDestList", ipmi_build_lan_destination_table_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_LAN_DEST_LIST, ACL_OBJ_IPMI_STATUS);

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static void display_destination_table(pp_strstream_t* tab, webs_t wp) {
    vector_t* destinations;
    unsigned int i;
    pp_ipmi_return_t ipmi_ret;
    
    /* read values from ipmi */
    memset(&ipmi_ret, 0, sizeof(ipmi_ret));
    if (!pp_ipmi_send_command(PP_IPMI_CMD_LAN, PP_IPMI_LAN_DESTINATION_GET, NULL, &ipmi_ret, NULL, wp->user)) {
        destinations = ipmi_ret.data.lan_destination_list;
    } else {
        destinations = NULL;
    }
    
#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "<table border=\"1\">\n");
#else
    pp_strappend(tab, "<script>\n");    
#endif
    add_destination_table_head(tab);
    if (destinations != NULL) {
        for (i=0; i<vector_size(destinations); i++) {
            add_destination_table_entry(tab, (pp_ipmi_lanp_dest_list_entry_t*)vector_get(destinations, i));
        }
    } else {
#if !defined(PP_FEAT_RARITAN_DESIGN)    
	pp_strappend(tab, "<tr><td colspan=5>");
	pp_strappend(tab, _("Error reading the LAN destinations"));
	pp_strappend(tab, "</td></tr>\n");
#else
        pp_strappend(tab, "table_entry('");
	pp_strappend(tab, _("Error reading the LAN destinations"));
    pp_strappend(tab, "','','','','','');</script>\n");
#endif	
    }
#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "</table>\n");
#else
    pp_strappend(tab, "\n</script>\n");    
#endif    
    
    vector_delete(destinations);
}
  
static void add_destination_table_head(pp_strstream_t *tab) {
#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "<tr>\n");
    pp_strappend(tab, "  <td class=\"bold\">ID</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Type</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Parameters</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Timeout</td>\n");
    pp_strappend(tab, "  <td class=\"bold\">Retries</td>\n");
    pp_strappend(tab, "</tr>\n");
#else /* PP_FEAT_RARITAN_DESIGN */
    (void)tab;
#endif /* PP_FEAT_RARITAN_DESIGN */
}

static void add_destination_table_entry(pp_strstream_t *tab, pp_ipmi_lanp_dest_list_entry_t *dest) {
    const unsigned char* bufp;
    unsigned char buf[512];
    assert(tab);
    assert(dest);
#if !defined(PP_FEAT_RARITAN_DESIGN)    
    pp_strappend(tab, "<tr>\n");
#else
    pp_strappend(tab, "\n table_entry(");
#endif    

    print_cell(tab, "%d", dest->id);

    bufp="unknown";
    if (dest->type == IPMI_ALERT_DEST_TYPE_PET) {
        bufp = "SNMP trap";
    }
    if (dest->type == IPMI_ALERT_DEST_TYPE_EMAIL) {
        bufp = "OEM1 (E-Mail)";
    }
    print_cell(tab, "%s", bufp);

    switch (dest->type) {
        case IPMI_ALERT_DEST_TYPE_PET:
            snprintf(buf, sizeof(buf), "IP %d.%d.%d.%d", dest->ip_addr[0],
                    dest->ip_addr[1], dest->ip_addr[2], dest->ip_addr[3]);
            print_cell(tab, "%s", buf);
            
            print_cell(tab, "%d", dest->timeout);
            print_cell(tab, "%d", dest->retries);
            break;
        case IPMI_ALERT_DEST_TYPE_EMAIL:
            print_cell(tab, "%s", dest->email);
            print_cell(tab, "%s", "-");
            print_cell(tab, "%s", "-");
            break;
        default:
            print_cell(tab, "%s", "-");
            print_cell(tab, "%s", "-");
            print_cell(tab, "%s", "-");
            break;
    }
#if !defined(PP_FEAT_RARITAN_DESIGN)        
    print_cell(tab, "<a href=\"ipmi_lan_dest_edit.asp?dest=%d\">[edit]</a>", dest->id);
    pp_strappend(tab, "</tr>\n");
#else
    print_cell(tab, "<a href=\"ipmi_lan_dest_edit.asp?dest=%d\">[edit]</a>'); //", dest->id);
#endif    
}

static int ipmi_build_lan_destination_table_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED) {
    pp_strstream_t tab = PP_STRSTREAM_INITIALIZER;

    pp_strstream_init(&tab);

    display_destination_table(&tab, wp);

    ejSetResult(eid, tab.buf ? tab.buf : "");

    pp_strstream_free(&tab);

    return 0;
}

