#include <liberic_config.h>
#include <pp/intl.h>
#include <pp/ipmi.h>
#include "ej.h"
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "eric_validate.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#include "tmpl_ipmi_common.h"

/* internal prototypes */
static int post_validate_hook(webs_t wp, form_handler_t * fh);
static void display_policy_table_edit(pp_strstream_t* tab, webs_t wp);
static void add_policy_table_head(pp_strstream_t *tab);
static void add_policy_table_entry(pp_strstream_t *tab, pp_ipmi_pef_policy_t *pol, int pol_edit_no);
static void add_policy_table_edit_entry(pp_strstream_t *tab, pp_ipmi_pef_policy_t *pol);
static int ipmi_build_policy_table_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED);


#define PP_LAN_CHANNEL  1

FV_SPEC = {
{
    id:             FV_ID_PEF_POLICY_ID,
    cfgkey:         "ipmi_policy_edit.id",
},
{
    id:             FV_ID_PEF_POLICY_ENABLE,
    cfgkey:         "ipmi_policy_edit.enable",
},
{
    id:             FV_ID_PEF_POLICY_SET,
    cfgkey:         "ipmi_policy_edit.policy_set",
},
{
    id:             FV_ID_PEF_POLICY_TYPE,
    cfgkey:         "ipmi_policy_edit.policy_type",
},
{
    id:             FV_ID_PEF_POLICY_CHANNEL,
    cfgkey:         "ipmi_policy_edit.channel",
},
{
    id:             FV_ID_PEF_POLICY_DESTINATION,
    cfgkey:         "ipmi_policy_edit.destination",
},
{
    id:             FV_ID_PEF_POLICY_ALERTSTR,
    cfgkey:         "ipmi_policy_edit.alertstring",
},
};


int ipmi_policy_edit_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("ipmiGetPolicyListEdit", ipmi_build_policy_table_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_POLICY_EDIT, ACL_OBJ_IPMI_STATUS);
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int post_validate_hook(webs_t wp, form_handler_t * fh)
{
    pp_ipmi_pef_policy_t* pol;
    pp_ipmi_parameter_t in_parm;
    int save_form;

    pol = &(in_parm.data.pef_policy_set);
    memset(pol, 0, sizeof(pp_ipmi_pef_policy_t));

    save_form = 0;
    if (form_button_clicked(wp, "action_apply")) {
        save_form = 1;
    }

    if (save_form == 1)
    {
        pol->id = strtol(fh->fv[FV_ID_PEF_POLICY_ID].val.s, NULL, 10);
        
        pol->number = strtol(fh->fv[FV_ID_PEF_POLICY_SET].val.s, NULL, 10);
        
        if (strcmp(fh->fv[FV_ID_PEF_POLICY_ENABLE].val.s, "enable") == 0) {
            pol->enable = 1;
        } else {
            pol->enable = 0;
        }
        
        pol->policy = 0;
        if (strcmp(fh->fv[FV_ID_PEF_POLICY_TYPE].val.s, "always") == 0) {
            pol->policy = 0;
        } if (strcmp(fh->fv[FV_ID_PEF_POLICY_TYPE].val.s, "next") == 0) {
            pol->policy = 1;
        } if (strcmp(fh->fv[FV_ID_PEF_POLICY_TYPE].val.s, "next_set") == 0) {
            pol->policy = 2;
        } if (strcmp(fh->fv[FV_ID_PEF_POLICY_TYPE].val.s, "next_channel") == 0) {
            pol->policy = 3;
        } if (strcmp(fh->fv[FV_ID_PEF_POLICY_TYPE].val.s, "next_destination") == 0) {
            pol->policy = 4;
        }
        
        pol->channel = strtol(fh->fv[FV_ID_PEF_POLICY_CHANNEL].val.s, NULL, 10);
        pol->destination = strtol(fh->fv[FV_ID_PEF_POLICY_DESTINATION].val.s, NULL, 10);
        pol->alert_string = strtol(fh->fv[FV_ID_PEF_POLICY_ALERTSTR].val.s, NULL, 10);
        
        if (pp_ipmi_send_command(PP_IPMI_CMD_PEF, PP_IPMI_PEF_POLICY_SET, &in_parm, NULL, NULL, wp->user)) {
            pp_log("liberic_webs.tmpl_ipmi_policy_edit.c - Error sending ipmi set policy command \n");
            set_response(wp, ERIC_RESPONSE_ERROR, _("Error sending the IPMI set policy command"));
            return -1;
        }
    }

    return 0;
}

static void display_policy_table_edit(pp_strstream_t* tab, webs_t wp) {
    vector_t* policies;
    unsigned int i;
    pp_ipmi_return_t ipmi_ret;
    const char* polNoStr;
    int polNo;
    int err;
    
    /* check if one entry can be edited */
    polNoStr = websGetVar(wp, "pol", "no_id");
    polNo = pp_strtoul_10(polNoStr, 0, &err);
    if (err) {
        polNo = -1;
    }
    
    /* read values from ipmi */
    memset(&ipmi_ret, 0, sizeof(ipmi_ret));
    if (!pp_ipmi_send_command(PP_IPMI_CMD_PEF, PP_IPMI_PEF_POLICY_GET, NULL, &ipmi_ret, NULL, wp->user)) {
        policies = ipmi_ret.data.pef_policy_list;
    } else {
        policies = NULL;
    }
    
#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "<table border=\"1\">\n");
#else
    pp_strappend(tab, "<table border=\"0\">\n");
#endif    
    add_policy_table_head(tab);
    if (policies != NULL) {
        for (i=0; i<vector_size(policies); i++) {
            add_policy_table_entry(tab, (pp_ipmi_pef_policy_t*)vector_get(policies, i), polNo);
        }
    } else {
        pp_strappend(tab, "<tr><td colspan=7>");
        pp_strappend(tab, _("Error reading the PEF policies"));
        pp_strappend(tab, "</td></tr>\n");
    }
    pp_strappend(tab, "</table>\n");
#if defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "\n<div class=\"tmpl_end\"><br></div>\n");    
#endif    
    vector_delete(policies);
}

static void add_policy_table_head(pp_strstream_t *tab) {
#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "<tr>\n  <td class=\"bold\">");
    pp_strappend(tab, _("Index"));
    pp_strappend(tab, "</td>\n  <td class=\"bold\">");
    pp_strappend(tab, _("Status"));
    pp_strappend(tab, "</td>\n  <td class=\"bold\">");
    pp_strappend(tab, _("Policy Set"));
    pp_strappend(tab, "</td>\n  <td class=\"bold\">");
    pp_strappend(tab, _("Policy"));
    pp_strappend(tab, "</td>\n  <td class=\"bold\">");
    pp_strappend(tab, _("Channel No."));
    pp_strappend(tab, "</td>\n  <td class=\"bold\">");
    pp_strappend(tab, _("Destination"));
    pp_strappend(tab, "</td>\n  <td class=\"bold\">");
    pp_strappend(tab, _("Alert String"));
    pp_strappend(tab, "</td>\n</tr>\n");
#else /* PP_FEAT_RARITAN_DESIGN */
   (void)tab;
#endif /* PP_FEAT_RARITAN_DESIGN */
}

static void add_policy_table_entry(pp_strstream_t *tab, pp_ipmi_pef_policy_t *pol, int pol_edit_no) {
    if (pol_edit_no != -1) {
        if (pol_edit_no == pol->id) {
            add_policy_table_edit_entry(tab, pol);
        }
    }
}

static void add_policy_table_edit_entry(pp_strstream_t *tab, pp_ipmi_pef_policy_t *pol) {
    assert(tab);
    assert(pol);
    pp_strappend(tab, "<tr>\n");

#if defined(PP_FEAT_RARITAN_DESIGN)    
    pp_strappend(tab, "<td class=\"settings_fieldname\">");
    pp_strappend(tab, _("Index"));
#endif
    print_input_cell(tab, FV_ID_PEF_POLICY_ID, "ipmipolicyedit", "text", "%d", pol->id, 5, 1);

#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "<td class=\"settings_fieldname\"><select ");
#else
    pp_strappend(tab, "</td></tr><tr><td class=\"settings_fieldname\">");
    pp_strappend(tab, _("Status"));
    pp_strappend(tab, "<br><select ");
#endif    
    print_fv(tab, FV_ID_PEF_POLICY_ENABLE, "ipmipolicyedit");
    pp_strappend(tab, ">\n");
    pp_strappend(tab, "<option value=\"enable\"");
    if (pol->enable == 1) pp_strappend(tab, " selected");
    pp_strappend(tab, ">");
    pp_strappend(tab, _("enable"));
    pp_strappend(tab, "\n<option value=\"disable\"");
    if (pol->enable == 0) pp_strappend(tab, " selected");
    pp_strappend(tab, ">");
    pp_strappend(tab, _("disable"));
    pp_strappend(tab, "\n</select></td>\n");
#if defined(PP_FEAT_RARITAN_DESIGN)    
    pp_strappend(tab, "</tr><tr><td class=\"settings_fieldname\">");
    pp_strappend(tab, _("Policy Set"));
#endif
    print_input_cell(tab, FV_ID_PEF_POLICY_SET, "ipmipolicyedit", "text", "%d", pol->number, 5, 0);
    
#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(tab, "<td class=\"settings_fieldname\"><select ");
#else
    pp_strappend(tab, "</td></tr><tr><td class=\"settings_fieldname\">");
    pp_strappend(tab, _("Policy"));
    pp_strappend(tab, "<br><select ");
#endif    
    print_fv(tab, FV_ID_PEF_POLICY_TYPE, "ipmipolicyedit");
    pp_strappend(tab, ">\n");
    pp_strappend(tab, "<option value=\"always\"");
    if (pol->policy == 1) pp_strappend(tab, " selected");
    pp_strappend(tab, ">");
    pp_strappend(tab, _("always"));
    pp_strappend(tab, "\n<option value=\"next\"");
    if (pol->policy == 1) pp_strappend(tab, " selected");
    pp_strappend(tab, ">");
    pp_strappend(tab, _("skip this destination"));
    pp_strappend(tab, "\n<option value=\"next_set\"");
    if (pol->policy == 1) pp_strappend(tab, " selected");
    pp_strappend(tab, ">");
    pp_strappend(tab, _("stop alerting"));
    pp_strappend(tab, "\n<option value=\"next_channel\"");
    if (pol->policy == 1) pp_strappend(tab, " selected");
    pp_strappend(tab, ">");
    pp_strappend(tab, _("skip to next channel"));
    pp_strappend(tab, "\n<option value=\"next_destination\"");
    if (pol->policy == 1) pp_strappend(tab, " selected");
    pp_strappend(tab, ">");
    pp_strappend(tab, _("skip to next destination"));
    pp_strappend(tab, "\n</select></td>\n");

#if !defined(PP_FEAT_RARITAN_DESIGN)
    print_input_cell(tab, FV_ID_PEF_POLICY_CHANNEL, "ipmipolicyedit", "text", "%d", pol->channel, 5, 0);
    print_input_cell(tab, FV_ID_PEF_POLICY_DESTINATION, "ipmipolicyedit", "text", "%d", pol->destination, 5, 0);
    print_input_cell(tab, FV_ID_PEF_POLICY_ALERTSTR, "ipmipolicyedit", "text", "%d", pol->alert_string, 5, 0);
#else
    pp_strappend(tab, "</tr><tr><td class=\"settings_fieldname\">");
    pp_strappend(tab, _("Channel No."));
    print_input_cell(tab, FV_ID_PEF_POLICY_CHANNEL, "ipmipolicyedit", "text", "%d", pol->channel, 5, 0);
    pp_strappend(tab, "</tr><tr><td class=\"settings_fieldname\">");
    pp_strappend(tab, _("Destination"));
    print_input_cell(tab, FV_ID_PEF_POLICY_DESTINATION, "ipmipolicyedit", "text", "%d", pol->destination, 5, 0);
    pp_strappend(tab, "</tr><tr><td class=\"settings_fieldname\">");
    pp_strappend(tab, _("Alert String"));
    print_input_cell(tab, FV_ID_PEF_POLICY_ALERTSTR, "ipmipolicyedit", "text", "%d", pol->alert_string, 5, 0);
#endif    
    pp_strappend(tab, "</tr>\n");
}

static int ipmi_build_policy_table_asp(int eid, webs_t wp, int argc UNUSED, char **argv UNUSED) {
    pp_strstream_t tab = PP_STRSTREAM_INITIALIZER;

    pp_strstream_init(&tab);

    display_policy_table_edit(&tab, wp);

    ejSetResult(eid, tab.buf ? tab.buf : "");

    pp_strstream_free(&tab);

    return 0;
}

