#if defined(PP_FEAT_IPMI_SHOW_SYSTEM_STATUS)

#include <pp/ipmi.h>
#include "ej.h"

#include "eric_util.h"
#include "eric_forms.h"

extern pp_ipmi_return_t sdr_list;
extern pthread_mutex_t sdr_list_mutex;

static int print_ipmi_system_status_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED);

FV_SPEC = {
};

int
ipmi_system_status_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("ipmiSystemStatus", print_ipmi_system_status_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_IPMI_SYSTEM_STATUS, ACL_OBJ_IPMI_STATUS);

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

typedef enum {
    SYSTEM_STATUS_OK = 0,
    SYSTEM_STATUS_WARNING = 1,
    SYSTEM_STATUS_ALERT = 2
} system_status_t;

static int print_ipmi_system_status_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char **argv UNUSED)
{
    pp_strstream_t result = PP_STRSTREAM_INITIALIZER;
    u_int i, sensor_cnt = 0;
    system_status_t status = SYSTEM_STATUS_OK;

    pthread_mutex_lock(&sdr_list_mutex);

#if !defined(PP_FEAT_RARITAN_DESIGN)
    pp_strappend(&result, "<table class=\"dialogTable center normal\" cellpadding=\"3\" cellspacing=\"0\">");
#else /* PP_FEAT_RARITAN_DESIGN */
    pp_strappend(&result, "<table class=\"tmpl_tab\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td></td></tr>");
#endif /* PP_FEAT_RARITAN_DESIGN */

    if (!sdr_list.data.sdr_list) 
    {
	pp_strappendf(&result, "<tr><td>%s</td></tr>", _("No sensor data available yet."));
	goto bail;
    }

    sensor_cnt = vector_size(sdr_list.data.sdr_list);
    if(sensor_cnt == 0) 
    {
	pp_strappendf(&result, "<tr><td>%s</td></tr>", _("No sensors found."));
	goto bail;
    }

    for (i = 0; i < sensor_cnt; i++) 
    {
	pp_ipmi_sdr_list_entry_t *entry = vector_get(sdr_list.data.sdr_list, i);
	if(entry->type==PP_IPMI_SENSOR_TYPE_FULL)
	    switch (entry->data.full.status)
	    {
		case PP_IPMI_SENSOR_STATUS_NO_READING:
		case PP_IPMI_SENSOR_STATUS_OK:
		    continue;
		case PP_IPMI_SENSOR_STATUS_UPPER_NON_CRITICAL:
		case PP_IPMI_SENSOR_STATUS_LOWER_NON_CRITICAL:
		    if (status < SYSTEM_STATUS_WARNING) {
		        status = SYSTEM_STATUS_WARNING;
		    }
		    break;
		default:
		    status = SYSTEM_STATUS_ALERT;
		    //printf("sensor %s has alert: %d.\n", entry->sdr_name.buf, entry->data.full.status);
		    // highest level, don't care for the others any more
		    goto have_info;
	    }
    }

 have_info:
    switch (status) {
        case SYSTEM_STATUS_OK:
            pp_strappendf(&result, "<tr><td style=\"background-color:#00FF00\">&nbsp;&nbsp;&nbsp;</td><td>%s</td></tr>", _("OK"));
            break;
        case SYSTEM_STATUS_WARNING:
            pp_strappendf(&result, "<tr><td style=\"background-color:#FFFF00\">&nbsp;&nbsp;&nbsp;</td><td>%s</td></tr>", _("Warning"));
            break;
        case SYSTEM_STATUS_ALERT:
            pp_strappendf(&result, "<tr><td style=\"background-color:#FF0000\">&nbsp;&nbsp;&nbsp;</td><td>%s</td></tr>", _("Alert"));
            break;    
    }

 bail:
    pp_strappend(&result, "</table>");
    ejSetResult(eid, pp_strstream_buf_and_free(&result));

    pthread_mutex_unlock(&sdr_list_mutex);
    return 0;
}

#endif /* PP_FEAT_IPMI_SHOW_SYSTEM_STATUS */
