#include <pp/km.h>
#include <pp/kvm.h>
#include <pp/um.h>
#include <pp/intl.h>
#include <liberic_misc.h>
#include "eric_validate.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "wsIntrn.h"

FV_SPEC = {
    {
	id:		FV_ID_KM_INPUT_TYPE,
	cfgkey:		"input_type"
    },
    {
	id:		FV_ID_KM_USB_TYPE,
	cfgkey:		"usb_type"
    },  
    {
	id:		FV_ID_KM_KBD_MODEL,
	cfgkey:		"unit[%N].port[%P].kbd.model",
    },    
#ifdef PP_FEAT_KBD_BREAK_TIMEOUT
    {
	id:		FV_ID_KM_KBD_BREAK_TIMEOUT_ENABLED,
	cfgkey:		"unit[%N].port[%P].kbd.break_timeout_enabled",
    },
    {
	id:		FV_ID_KM_KBD_BREAK_TIMEOUT_MSEC,
	cfgkey:		"unit[%N].port[%P].kbd.break_timeout_msec",
    },
#endif /* PP_FEAT_KBD_BREAK_TIMEOUT */
    {
	id:		FV_ID_KM_MOUSE_MODE,
	cfgkey:		"unit[%N].port[%P].mouse.mode",
    },
    {
	id:		FV_ID_KM_DIRECT_MOUSE_SCALING,
	cfgkey:		"unit[%N].port[%P].mouse.direct_scaling",
    },
#ifdef PP_FEAT_MOUSE_G_UND_D
    {
	id:		FV_ID_KM_GUD_MOUSE_EQZ,
	cfgkey:		"unit[%N].port[%P].mouse.gud_eqz",
    },
    {
	id:		FV_ID_KM_GUD_MOUSE_EQZ_PRESET,
	cfgkey:		"unit[%N].port[%P].mouse.gud_eqz_preset",
    },
    {
	id:		FV_ID_KM_GUD_MOUSE_EQZ_ID,
	cfgkey:		"unit[%N].port[%P].mouse.gud_eqz_id",
    },
#endif /* PP_FEAT_MOUSE_G_UND_D */

#ifdef PP_FEAT_CAT
    {
	id:		FV_ID_KM_CAT,
	cfgkey:		"unit[%N].port[%P].mouse.cat",
    },
#endif /* PP_FEAT_CAT */
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);
static int km_is_ps2_supported_asp(int eid, webs_t wp, int argc, char ** argv);
static int km_is_usb_supported_asp(int eid, webs_t wp, int argc, char ** argv);
static int km_is_usb_active_asp(int eid, webs_t wp, int argc, char ** argv);

int
km_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("kmIsPS2Supported", km_is_ps2_supported_asp);
    websAspDefine("kmIsUsbSupported", km_is_usb_supported_asp);
    websAspDefine("kmIsUsbActive", km_is_usb_active_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_KM, ACL_OBJ_KM);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    if (form_button_clicked(wp, "action_apply")) {
	/* disable part of the km settings, depending on
	   interface availability and selection */
	if (!pp_km_is_usb_possible(0) || !pp_km_is_ps2_possible(0)) {
	    fh->fv[FV_ID_KM_INPUT_TYPE].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	}
	if (!pp_km_is_usb_possible(0)
	    || !strcmp(fh->fv[FV_ID_KM_INPUT_TYPE].val.s, "ps2")) {
	    fh->fv[FV_ID_KM_USB_TYPE].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	}
	if (!pp_km_is_ps2_possible(0)
	    || !strcmp(fh->fv[FV_ID_KM_INPUT_TYPE].val.s, "usb")) {
	    fh->fv[FV_ID_KM_KBD_MODEL].flags |= FV_FLAG_SKIP_VALIDATE | FV_FLAG_DONT_SAVE;
	}
	
    }
    return 0;
}

static int
km_is_ps2_supported_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char ** argv UNUSED)
{
    ejSetResult(eid, pp_km_is_ps2_possible(0) ? "1" : "0");
    return 0;
}

static int
km_is_usb_supported_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char ** argv UNUSED)
{
    ejSetResult(eid, pp_km_is_usb_possible(0) ? "1" : "0");
    return 0;
}

static int
km_is_usb_active_asp(int eid, webs_t wp UNUSED, int argc UNUSED, char ** argv UNUSED)
{
    ejSetResult(eid, pp_km_is_usb_active(0) ? "1" : "0");
    return 0;
}
