#include <pp/base.h>
#include <pp/powerswitch.h>
#include <pp/um.h>
#include <pp/intl.h>
#include <liberic_misc.h>
#include <pp/rfb.h>
#include <pp/kvm.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "wsIntrn.h"

FV_SPEC = {
};

static int post_validate_hook(webs_t wp, form_handler_t * fh);

int
kvm_port_list_tmpl_init(void)
{
    form_handler_t * fh;

    if (kvm_common_tmpl_init() != 0) return -1;
    
    fh = CREATE_FH_INSTANCE(TEMPLATE_KVM_PORT_LIST, ACL_OBJ_KVM_PORTS);

    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    u_char channel;
    u_char unit;
    u_short port;
    const char * port_var_name;
    
    /* FIXME: allow more than 2 channels! */
    if (form_button_clicked(wp, "action_switch_0") || form_button_clicked(wp, "action_switch_1")) {

	wp->fh_flags |= FH_FLAG_SKIP_SAVE;

	if (!(PP_SUC == pp_um_user_has_permission(wp->user, "kvm",
                                                  pp_acl_raasip_yes_str) ||
	      PP_SUC == pp_um_user_has_permission(wp->user, "kvm_s",
                                                  pp_acl_raasip_yes_str))) {
	    eric_notify_security_violation(wp->session);
	    set_response(wp, ERIC_RESPONSE_ERROR, perm_denied_msg);
	    goto fail;
	}
	/* FIXME: allow more than 2 channels! */
	if (form_button_clicked(wp, "action_switch_0")) {
	    channel = 0;
	    port_var_name = "kvm_active_port_0";
	} else {
	    channel = 1;
	    port_var_name = "kvm_active_port_1";
	}
	port = pp_strtoul_10(websGetVar(wp, port_var_name, "0"), 0, NULL);
	if (pp_rfb_get_exclusive_session_info(wp->session) == PP_RFB_SESSION_NOT_EXCLUSIVE) {
	    set_response(wp, ERIC_RESPONSE_ERROR, _("Permission denied. There is an exclusive session active."));
	    goto fail;
	}
	/* TODO: at some point we may have to deal with kvm unit != 0 */
	if (!pp_kvm_switch_allowed(wp->user, 0/* unit */, port)) {
	    set_response(wp, ERIC_RESPONSE_ERROR, perm_denied_msg);
	    goto fail;
	}
	/* FIXME: kvm_switch_port */
	if (pp_kvm_switch_port(NULL, 0/* unit */, port, NULL, NULL) != 0) {
	    char port_str_buf[11];
	    set_response(wp, ERIC_RESPONSE_ERROR, _("Could not switch ports"));
	    if (pp_kvm_get_unit_port_for_video_link(channel, &unit, &port) != 0) {
		/* FIXME */
		unit = 0;
		port = 0;
	    }
	    snprintf(port_str_buf, sizeof(port_str_buf), "%u", port);
	    websSetVar(wp, port_var_name, port_str_buf);
	} else {
	    set_response(wp, ERIC_RESPONSE_OK, _("Port switched successfully."));
	    /* wait a little bit to get a stable screenshoot *
	     * (little bit ugly, I do confess ;-)            */
	    sleep(1);
	}	
    }
    return 0;

fail:
    return -1;
}
