#include <pp/base.h>
#include <pp/kvm.h>
#include <pp/powerswitch.h>
#include <pp/intl.h>
#include <pp/um.h>
#include <liberic_config.h>
#include <liberic_misc.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_forms.h"
#include "wsIntrn.h"

#if defined(PP_FEAT_POWER_CTRL_ENABLE)

FV_SPEC = {
};

static int post_validate_hook(webs_t wp, form_handler_t * fh);
static void set_pswitch_form_vars(webs_t wp);
static int kvm_pc_init_form_vars_asp(int eid, webs_t wp, int argc, char ** argv);
static void kvm_pc_get_cfg(u_char kvm_unit, u_short kvm_port, u_int power_port,
			   u_int * serial_port_p, u_int * device_p, u_int * port_p,
			   char ** type_p);
static void kvm_pc_set_cfg(u_char kvm_unit, u_short kvm_port, u_int power_port,
			   u_int serial_port, u_int device, u_int port,
			   const char * type);

int
kvm_power_ctrl_tmpl_init(void)
{
    form_handler_t * fh;   

    /* register ASPs */
    websAspDefine("kvmPCInitFormVars", kvm_pc_init_form_vars_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_KVM_POWER_CTRL, ACL_OBJ_KVM_S);
                         
    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    u_char kvm_unit;
    u_short kvm_port;
    u_int i, entry_cnt;
    int err;
    char val[11];
    const char * str;
    const char * device_webs_var_name = NULL;
    const char * port_webs_var_name = NULL;
    const char * ps_type_webs_var_name = NULL;
    u_int serial_port, device = UINT_MAX, port = UINT_MAX;
    const char * ps_type = NULL;
    u_int serial_port_tmp, device_tmp, port_tmp;
    char * ps_type_tmp;
    u_int serial_port_tmp2, device_tmp2, port_tmp2;
    char * ps_type_tmp2;
    u_int sel_power_port;

    set_pswitch_form_vars(wp);

    str = websGetVar(wp, "__target_unit__", NULL);
    kvm_unit = pp_strtoul_10(str, 0, &err);
    if (err) return 0;
    str = websGetVar(wp, "__target_port__", NULL);
    kvm_port = pp_strtoul_10(str, 0, &err);
    if (err) return 0;

    serial_port = pp_strtoul_10(websGetVar(wp, "_kvm_pc_serial_port", NULL), UINT_MAX, NULL);
    if (serial_port == 0) {
	device_webs_var_name = "_kvm_pc_ps_tty0_device";
	port_webs_var_name = "_kvm_pc_ps_tty0_port";
	ps_type_webs_var_name = "_kvm_pc_ps_tty0_type";
    } else if (serial_port == 1) {
	device_webs_var_name = "_kvm_pc_ps_tty1_device";
	port_webs_var_name = "_kvm_pc_ps_tty1_port";
	ps_type_webs_var_name = "_kvm_pc_ps_tty1_type";
    }

    if (device_webs_var_name) {
	device = pp_strtoul_10(websGetVar(wp, device_webs_var_name, NULL), UINT_MAX, NULL);
	port = pp_strtoul_10(websGetVar(wp, port_webs_var_name, NULL), UINT_MAX, NULL);
	ps_type = websGetVar(wp, ps_type_webs_var_name, NULL);
    }
	
    
    pp_cfg_get_uint(&entry_cnt, "unit[%u].port[%u].powerports._s_", kvm_unit, kvm_port);

    sel_power_port = pp_strtoul_10(websGetVar(wp, "_kvm_pc_powerport", NULL), entry_cnt, NULL);
    if (sel_power_port >= entry_cnt) return 0;
    
    /* button handling */
    if (form_button_clicked(wp, "action_port_append")) {
	/* if device, port or type is not set, save nothing */
	if (device == UINT_MAX || port == UINT_MAX || ps_type == NULL) return 0;
	/* append entry */
	pp_cfg_set_int(++entry_cnt, "unit[%u].port[%u].powerports._s_", kvm_unit, kvm_port);
	kvm_pc_set_cfg(kvm_unit, kvm_port, entry_cnt - 1, serial_port, device, port, ps_type);
    } else if (form_button_clicked(wp, "action_port_delete")) {
	/* close hole - move entries downwards */
	for (i = sel_power_port; i < entry_cnt - 1; ++i) {
	    kvm_pc_get_cfg(kvm_unit, kvm_port, i + 1, &serial_port_tmp, &device_tmp, &port_tmp, &ps_type_tmp);
	    kvm_pc_set_cfg(kvm_unit, kvm_port, i, serial_port_tmp, device_tmp, port_tmp, ps_type_tmp);
	    free(ps_type_tmp);
	}
	pp_cfg_set_int(--entry_cnt, "unit[%u].port[%u].powerports._s_", kvm_unit, kvm_port);
    } else if (form_button_clicked(wp, "action_port_insert")) {
	/* if device, port or type is not set, save nothing */
	if (device == UINT_MAX || port == UINT_MAX || ps_type == NULL) return 0;
	/* create hole - move entries upwards */
	pp_cfg_set_int(++entry_cnt, "unit[%u].port[%u].powerports._s_", kvm_unit, kvm_port);
	for (i = entry_cnt - 1; i >= sel_power_port; --i) {
	    kvm_pc_get_cfg(kvm_unit, kvm_port, i, &serial_port_tmp, &device_tmp, &port_tmp, &ps_type_tmp);
	    kvm_pc_set_cfg(kvm_unit, kvm_port, i + 1, serial_port_tmp, device_tmp, port_tmp, ps_type_tmp);
	    free(ps_type_tmp);
	}
	/* insert entry */
	kvm_pc_set_cfg(kvm_unit, kvm_port, sel_power_port, serial_port, device, port, ps_type);
    } else if (form_button_clicked(wp, "action_port_up")) {
	if (sel_power_port > 0) {
	    kvm_pc_get_cfg(kvm_unit, kvm_port, sel_power_port, &serial_port_tmp, &device_tmp, &port_tmp, &ps_type_tmp);
	    kvm_pc_get_cfg(kvm_unit, kvm_port, sel_power_port - 1, &serial_port_tmp2, &device_tmp2, &port_tmp2, &ps_type_tmp2);
	    kvm_pc_set_cfg(kvm_unit, kvm_port, sel_power_port, serial_port_tmp2, device_tmp2, port_tmp2, ps_type_tmp2);
	    kvm_pc_set_cfg(kvm_unit, kvm_port, sel_power_port - 1, serial_port_tmp, device_tmp, port_tmp, ps_type_tmp);

	    snprintf(val, sizeof(val), "%u", sel_power_port - 1);
	    websSetVar(wp, "_kvm_pc_powerport", val);

	    free(ps_type_tmp);
	    free(ps_type_tmp2);
	}
    } else if (form_button_clicked(wp, "action_port_down")) {
	if (sel_power_port < entry_cnt - 1) {
	    kvm_pc_get_cfg(kvm_unit, kvm_port, sel_power_port, &serial_port_tmp, &device_tmp, &port_tmp, &ps_type_tmp);
	    kvm_pc_get_cfg(kvm_unit, kvm_port, sel_power_port + 1, &serial_port_tmp2, &device_tmp2, &port_tmp2, &ps_type_tmp2);
	    kvm_pc_set_cfg(kvm_unit, kvm_port, sel_power_port, serial_port_tmp2, device_tmp2, port_tmp2, ps_type_tmp2);
	    kvm_pc_set_cfg(kvm_unit, kvm_port, sel_power_port + 1, serial_port_tmp, device_tmp, port_tmp, ps_type_tmp);

	    snprintf(val, sizeof(val), "%u", sel_power_port + 1);
	    websSetVar(wp, "_kvm_pc_powerport", val);

	    free(ps_type_tmp);
	    free(ps_type_tmp2);
	}
    } else {
	return 0;
    }    
    
    pp_cfg_save(DO_FLUSH);
    return 0;
}

static void
set_pswitch_form_vars(webs_t wp)
{
    int i, dev_cnt, port_cnt;
    char var_name[MAX_OPT_KEY_LEN + 1];
    char cnt_val[MAX_OPT_VALUE_LEN + 1];
    char * val;

    /* ------------------------------------------------------------------------
     * fill the power entry list for serial port 1     
     */    
    if (PP_SUCCED(pp_power_login(PP_POWER_PORT_ID_SERIAL_1))) {
	
	dev_cnt = pp_power_get_count(0, PWR_OBJ_DEVICE, PP_POWER_PORT_ID_SERIAL_1);
	pp_log("Dev Count: %d\n", dev_cnt);
	port_cnt = pp_power_get_count(0, PWR_OBJ_PORT, PP_POWER_PORT_ID_SERIAL_1);
	pp_log("Port Count: %d\n", port_cnt);
	val = pp_power_get_name(0, 0, PWR_OBJ_SWITCH_ID, PP_POWER_PORT_ID_SERIAL_1);
	websSetVar(wp, "_kvm_pc_ps_tty0_type", val);
	free(val);
	val = pp_power_get_name(0, 0, PWR_OBJ_SWITCH_SHORT_NAME, PP_POWER_PORT_ID_SERIAL_1);
	if (val) websSetVar(wp, "_kvm_pc_ps_tty0_name", val);
	free(val);

	if (dev_cnt < 0) dev_cnt = 0;
	if (port_cnt < 0) port_cnt = 0;

	snprintf(cnt_val, sizeof(cnt_val), "%u", dev_cnt);
	websSetVar(wp, "_kvm_pc_ps_tty0_device_cnt", cnt_val);    
	
	for (i = 0; i < dev_cnt; i++) {
            form_var_vec_name("_kvm_pc_ps_tty0_devices", i, 
                              var_name, sizeof(var_name));
	    val = pp_power_get_name(0, i, PWR_OBJ_DEVICE, PP_POWER_PORT_ID_SERIAL_1);
	    websSetVar(wp, var_name, val);
	    free(val);
	}

	if (port_cnt > 0) {
	    snprintf(cnt_val, sizeof(cnt_val), "%u", port_cnt);
	    websSetVar(wp, "_kvm_pc_ps_tty0_port_cnt", cnt_val);
	    for (i = 0; i < port_cnt; i++) {
                form_var_vec_name("_kvm_pc_ps_tty0_ports", i, 
                                  var_name, sizeof(var_name));
		val = pp_power_get_name(i, 0, PWR_OBJ_PORT, PP_POWER_PORT_ID_SERIAL_1);
		websSetVar(wp, var_name, val);
		free(val);
	    }
	}	
	pp_power_logout(PP_POWER_PORT_ID_SERIAL_1);
    }
    
    /* ------------------------------------------------------------------------
     * fill the power entry list for serial port 2
     */
    if (PP_SUCCED(pp_power_login(PP_POWER_PORT_ID_SERIAL_2))) {
	dev_cnt = pp_power_get_count(0, PWR_OBJ_DEVICE, PP_POWER_PORT_ID_SERIAL_2);
	pp_log("Dev Count P2: %d\n", dev_cnt);
	port_cnt = pp_power_get_count(0, PWR_OBJ_PORT, PP_POWER_PORT_ID_SERIAL_2);
	pp_log("Port Count P2: %d\n", port_cnt);
	val = pp_power_get_name(0, 0, PWR_OBJ_SWITCH_ID, PP_POWER_PORT_ID_SERIAL_2);
	websSetVar(wp, "_kvm_pc_ps_tty1_type", val);
	free(val);
	val = pp_power_get_name(0, 0, PWR_OBJ_SWITCH_SHORT_NAME, PP_POWER_PORT_ID_SERIAL_2);
	if (val) websSetVar(wp, "_kvm_pc_ps_tty1_name", val);
	free(val);
	
	if (dev_cnt < 0) dev_cnt = 0;
	if (port_cnt < 0) port_cnt = 0;

	snprintf(cnt_val, sizeof(val), "%u", dev_cnt);
	websSetVar(wp, "_kvm_pc_ps_tty1_device_cnt", cnt_val);

	for (i = 0; i < dev_cnt; i++) {
            form_var_vec_name("_kvm_pc_ps_tty1_devices", i,
                              var_name, sizeof(var_name));
	    val = pp_power_get_name(0, i, PWR_OBJ_DEVICE, PP_POWER_PORT_ID_SERIAL_2);
	    websSetVar(wp, var_name, val);
	    free(val);
	}
	
	if (port_cnt > 0) {
	    snprintf(cnt_val, sizeof(val), "%u", port_cnt);
	    websSetVar(wp, "_kvm_pc_ps_tty1_port_cnt", cnt_val);
	    for (i = 0; i < port_cnt; i++) {
                form_var_vec_name("_kvm_pc_ps_tty1_ports", i, 
                                  var_name, sizeof(var_name));
		val = pp_power_get_name(i, 0, PWR_OBJ_PORT, PP_POWER_PORT_ID_SERIAL_2);
		websSetVar(wp, var_name, val);
		free(val);
	    }
	}
	pp_power_logout(PP_POWER_PORT_ID_SERIAL_2);
    }
}

static int
kvm_pc_init_form_vars_asp(int eid UNUSED, webs_t wp, int argc UNUSED, char ** argv UNUSED)
{
    u_char kvm_unit;
    u_short kvm_port;
    u_int i, serial_port, entry_cnt;
    u_int list_cnt = 0;
    int err;
    char var_name[MAX_OPT_KEY_LEN + 1];
    char power_port_str[64];
    const char * str;
    char * ps_type;
    char * pswitch_vendor;
    char * cur_ps_type;

    if (!form_was_submitted(wp)) set_pswitch_form_vars(wp);

    str = websGetVar(wp, "__target_unit__", NULL);
    kvm_unit = pp_strtoul_10(str, 0, &err);
    if (err) return 0;
    str = websGetVar(wp, "__target_port__", NULL);
    kvm_port = pp_strtoul_10(str, 0, &err);
    if (err) return 0;

    pp_cfg_get_uint(&entry_cnt, "unit[%u].port[%u].powerports._s_", kvm_unit, kvm_port);
    
    /* write all listbox entrys to asp */
    for ( i = 0; i < entry_cnt; i++ ) {
	u_int port_id, device, port;
	/* get kvm power port config string for kvm port 'kvm_port_id' and id 'i' */
	kvm_pc_get_cfg(kvm_unit, kvm_port, i, &serial_port, &device, &port, &ps_type);
	++serial_port;
	port_id = pp_power_map_serial_port_to_id(serial_port);

	if (PP_SUCCED(pp_power_login(port_id))) {
	    pswitch_vendor = pp_power_get_long_name(ps_type);
	    /* get the switch id of the power switch that is currently set and look
	     * if it matches the switch id of the kvm power port... */
	    cur_ps_type = pp_power_get_name(0, 0, PWR_OBJ_SWITCH_ID, port_id);

	    if (!cur_ps_type || strcmp(cur_ps_type, ps_type)) {
		/*
		 * ...if not, simply write: 'power_switch' is unavailable!
		 * as designed, we only get port and device names from the power
		 * switch that is currently set in serial settings, so the
		 * 'unavailable' message circumvent this constraint
		 */
		snprintf(power_port_str, sizeof(power_port_str),
			 _("Serial %d - %s is unavailable!"), serial_port, pswitch_vendor);	
	    } else {
		/* here we get port and device names and write all the power port
		 * data to a single string */
		char * lst_devname = pp_power_get_name(0, device, PWR_OBJ_DEVICE, port_id);
		char * lst_portname = pp_power_get_name(port, 0, PWR_OBJ_PORT, port_id);
		if (lst_devname) {
		    snprintf(power_port_str, sizeof(power_port_str),
			     _("Serial %d - %s - %s - %s"), serial_port, pswitch_vendor, lst_devname, lst_portname);
		} else {
		    snprintf(power_port_str, sizeof(power_port_str),
			     _("Serial %d - %s - %s"), serial_port, pswitch_vendor, lst_portname);
		}
		free(lst_devname);
		free(lst_portname);
	    }
	    free(cur_ps_type);
	    free(pswitch_vendor);
/* FIXME: FIXME - maybe we should not logout here since login/logout takes long sometimes */
	    pp_power_logout(port_id);
	}
	/* write the power port string to the web page, later shown as a line	   
	 * in the list box */
	++list_cnt;
	form_var_vec_name("_kvm_pc_powerports", i, var_name, sizeof(var_name));
	websSetVar(wp, var_name, power_port_str);		   
	free(ps_type);
    }
    /* set list box entry count to asp */
    snprintf(var_name, sizeof(var_name), "%u", list_cnt);
    websSetVar(wp, "_kvm_pc_powerports_cnt", var_name);
    return 0;
}

static void
kvm_pc_get_cfg(u_char kvm_unit, u_short kvm_port, u_int power_port,
	       u_int * serial_port_p, u_int * device_p, u_int * port_p, char ** type_p)
{
    pp_cfg_get_uint(serial_port_p, "unit[%u].port[%u].powerports[%u].serial_port", kvm_unit, kvm_port, power_port);
    pp_cfg_get_uint(device_p, "unit[%u].port[%u].powerports[%u].ps.device", kvm_unit, kvm_port, power_port);
    pp_cfg_get_uint(port_p, "unit[%u].port[%u].powerports[%u].ps.port", kvm_unit, kvm_port, power_port);
    pp_cfg_get(type_p, "unit[%u].port[%u].powerports[%u].ps.type", kvm_unit, kvm_port, power_port);
}

static void
kvm_pc_set_cfg(u_char kvm_unit, u_short kvm_port, u_int power_port,
	       u_int serial_port, u_int device, u_int port, const char * type)
{
    pp_cfg_set_uint(serial_port, "unit[%u].port[%u].powerports[%u].serial_port", kvm_unit, kvm_port, power_port);
    pp_cfg_set_uint(device, "unit[%u].port[%u].powerports[%u].ps.device", kvm_unit, kvm_port, power_port);
    pp_cfg_set_uint(port, "unit[%u].port[%u].powerports[%u].ps.port", kvm_unit, kvm_port, power_port);
    pp_cfg_set(type, "unit[%u].port[%u].powerports[%u].ps.type", kvm_unit, kvm_port, power_port);
}

#else /* !PP_FEAT_POWER_CTRL_ENABLE */

int kvm_power_ctrl_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_POWER_CTRL_ENABLE */
