#include <pp/base.h>
#include <pp/intl.h>
#include "eric_base.h"
#include "eric_forms.h"
#include "eric_util.h"
#include "webs.h"
#include "wsIntrn.h"

#if defined(PP_FEAT_REMOTE_CONSOLE)
#include <pp/rfb.h>
#endif

FV_SPEC = {
    {
	id:	        FV_ID_LANGUAGE,
	cfgkey:		"language"
    }
};

static int post_save_hook(webs_t wp, form_handler_t * fh UNUSED);
   
int
language_tmpl_init(void)
{
    form_handler_t * fh;
    fh = CREATE_FH_INSTANCE(TEMPLATE_LANGUAGE, ACL_OBJ_LANGUAGE);

    fh->post_save_hook = post_save_hook;
    
    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_save_hook(webs_t wp, form_handler_t * fh UNUSED) {

    char* lngold;

	lngold = (char *) malloc (8);
	stpcpy (lngold, pp_intl_get_language_shortname());

	pp_intl_set_language(fh->fv[FV_ID_LANGUAGE].val.s);

	if (!strcmp(pp_intl_get_language_shortname(), fh->fv[FV_ID_LANGUAGE].val.s)) {
	    const char *charset;
	    if ((charset = pp_intl_get_charset()) == NULL) {
	        pp_log("WARNING: No charset for language '%s' found. "
	               "This might cause problems !\n", fh->fv[FV_ID_LANGUAGE].val.s);
	    }
#if defined(PP_FEAT_REMOTE_CONSOLE)
            else {
                pp_rfb_send_command(PP_RFB_CLIENT_TYPE_ALL, 0, "charset", charset);
            }
#endif
      	    set_response(wp, ERIC_RESPONSE_OK, _("New language set.\n Reload this site to apply the new settings to the whole homepage."));
	    websSetVar(wp, "_show_redirect_info", "1");
	} else {
	    pp_intl_set_language(lngold);
	    set_response(wp, ERIC_RESPONSE_ERROR, _("Setting new language failed."));
	    if (pp_intl_get_charset() == NULL) pp_log("WARNING: No charset for language '%s' found. "
						      "This might cause problems !\n", lngold);
	    free(lngold);
	    return PP_ERR;
	}

	free(lngold);

	return PP_SUC;
}
