#include <liberic_config.h>
#include <liberic_notify.h>
#include <pp/cfg.h>
#include "eric_validate.h"
#include "eric_util.h"
#include "eric_forms.h"

FV_SPEC = {
};

static int post_validate_hook(webs_t wp, form_handler_t * fh);
static int log_assign_set_evt_vars_asp(int eid, webs_t wp, int argc, char ** argv);
static int log_assign_set_obj_vars_asp(int eid, webs_t wp, int argc, char ** argv);
static int log_assign_set_obj_defaults_asp(int eid, webs_t wp, 
                                           int argc, char ** argv);

int
log_assign_tmpl_init(void)
{
    form_handler_t * fh;

    /* register ASPs */
    websAspDefine("logAssignSetEvtVars", log_assign_set_evt_vars_asp);
    websAspDefine("logAssignSetObjVars", log_assign_set_obj_vars_asp);
    websAspDefine("logAssignSetObjDefaults", log_assign_set_obj_defaults_asp);

    fh = CREATE_FH_INSTANCE(TEMPLATE_LOG_ASSIGN, ACL_OBJ_LOG_S);

    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_validate_hook(webs_t wp, form_handler_t * fh UNUSED)
{
    char tmp_str[MAX_OPT_KEY_LEN+1], config_var[MAX_OPT_KEY_LEN+1];
    const char *list, *snmp, *smtp, *nfs;
    int error;
    evt_type_entry_t *object;

    for (object = eric_notify_get_first_event_obj(); object; object = eric_notify_get_next_event_obj()) {

	snprintf(tmp_str, sizeof(tmp_str), "%s_list_enabled", object->name);
	list = websGetVar(wp, tmp_str, NULL);
	object->list_enabled = list ? 1 : 0;

	snprintf(tmp_str, sizeof(tmp_str), "%s_snmp_enabled", object->name);
	snmp = websGetVar(wp, tmp_str, NULL);
	object->snmp_enabled = snmp ? 1 : 0;

	snprintf(tmp_str, sizeof(tmp_str), "%s_smtp_enabled", object->name);
	smtp = websGetVar(wp, tmp_str, NULL);
	object->smtp_enabled = smtp ? 1 : 0;

	snprintf(tmp_str, sizeof(tmp_str), "%s_nfs_enabled", object->name);
	nfs = websGetVar(wp, tmp_str, NULL);
	object->nfs_enabled = nfs ? 1 : 0;
            
	snprintf(tmp_str, sizeof(tmp_str), "%s:%s:%s:%s", 
		 list ? "log"  : "", 
		 snmp ? "snmp" : "",
		 smtp ? "smtp" : "",
		 nfs  ? "nfs"  : "");
                            
	snprintf(config_var, sizeof(config_var), "log.event[%s]", object->name);
            
	error = pp_cfg_set(tmp_str, config_var);

	if (error) {
	    set_response(wp, ERIC_RESPONSE_ERROR, pp_error_string(errno));
	    return -1;
	}
    }
    
    /* form_handler() will flush changes */
    error = pp_cfg_save(DONT_FLUSH);

    if (error) {
	set_response(wp, ERIC_RESPONSE_ERROR, pp_error_string(errno));
	return -1;
    }

    return 0;
}
 
static int
log_assign_set_evt_vars_asp(int eid UNUSED, webs_t wp, int argc UNUSED, char ** argv UNUSED)
{
    char tmp_str[MAX_OPT_KEY_LEN+1];
    int i = 0, cnt = eric_notify_get_object_cnt();    
    evt_type_entry_t *object;
    
    snprintf(tmp_str, sizeof(tmp_str), "%d", cnt);
    websSetVar(wp, "_log_evt_type_cnt", tmp_str);

    if (i < cnt) {
	if ((object = eric_notify_get_first_event_obj()) != NULL) {
            form_var_vec_name("_log_evt_type", i, tmp_str, sizeof(tmp_str));
	    websSetVar(wp, tmp_str, object->name);
	}
    }
    
    for (i = 1; i < cnt; i++) {
	if ((object = eric_notify_get_next_event_obj()) != NULL) {
            form_var_vec_name("_log_evt_type", i, tmp_str, sizeof(tmp_str));
	    websSetVar(wp, tmp_str, object->name); 
	}
    }

    return 0;
}

static int
log_assign_set_obj_vars_asp(int eid UNUSED, webs_t wp, int argc, char ** argv)
{   
    evt_type_entry_t *object;

    if (argc == 1) {
	object = eric_notify_get_event_object(argv[0]);
        websSetVar(wp, "_log_obj_long_name", object->longname);
        websSetVar(wp, "_log_obj_list_enabled", object->list_enabled ? "1" : "0"); 
        websSetVar(wp, "_log_obj_list_shown", object->flags & PP_NOTIFY_EVENT_LIST_ENABLE ? "1" : "0");
	websSetVar(wp, "_log_obj_nfs_enabled", object->nfs_enabled ? "1" : "");
        websSetVar(wp, "_log_obj_nfs_shown", object->flags & PP_NOTIFY_EVENT_NFS_ENABLE ? "1" : "0");
	websSetVar(wp, "_log_obj_smtp_enabled", object->smtp_enabled ? "1" : "");
        websSetVar(wp, "_log_obj_smtp_shown", object->flags & PP_NOTIFY_EVENT_SMTP_ENABLE ? "1" : "0");
        websSetVar(wp, "_log_obj_snmp_enabled", object->snmp_enabled ? "1" : "");            
        websSetVar(wp, "_log_obj_snmp_shown", object->flags & PP_NOTIFY_EVENT_SNMP_ENABLE ? "1" : "0");
    }

    return 0;
}

static int
log_assign_set_obj_defaults_asp(int eid UNUSED, webs_t wp, 
                                int argc, char ** argv)
{   
    if (argc == 1) {
        char *log_evt;
        
        pp_cfg_get_at_layer(PP_PROFILE_DEFAULTS, &log_evt,
                            "log.event[%s]", argv[0]);
        
        websSetVar(wp, "_log_obj_list_enabled_default", 
                   strstr(log_evt, "log") ? "1" : "0"); 
	websSetVar(wp, "_log_obj_nfs_enabled_default",
                   strstr(log_evt, "nfs") ? "1" : "0");
	websSetVar(wp, "_log_obj_smtp_enabled_default",
                   strstr(log_evt, "smtp") ? "1" : "0");
        websSetVar(wp, "_log_obj_snmp_enabled_default",
                   strstr(log_evt, "snmp") ? "1" : "0"); 
        
        free(log_evt);
    }

    return 0;
}
