#include "eric_forms.h"

FV_SPEC = {
    {
	id:		FV_ID_LOG_SMTP_ENABLED,
	cfgkey:		"log.smtp.enabled"
    },
    {
	id:		FV_ID_LOG_SMTP_LOG_ADDR,
	cfgkey:		"log.smtp.to"
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
log_smtp_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_LOG_SMTP, ACL_OBJ_LOG_S);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    if (pp_strcmp_safe(fh->fv[FV_ID_LOG_SMTP_ENABLED].val.s, "yes")) {
	fh_disable_validate_and_save(fh, FV_ID_LOG_SMTP_ENABLED);
    }
    return 0;
}

