#include <liberic_notify.h>
#include <pp/intl.h>
#include <pp/cfg.h>
#include "eric_validate.h"
#include "eric_forms.h"

FV_SPEC = {
    {
	id:		FV_ID_LOG_SNMP_ENABLED,
	cfgkey:		"log.snmp.enabled"
    },
    {
	id:		FV_ID_LOG_SNMP_TRAP_DEST_IP,
	cfgkey:		"snmp.trap.dest[%I]",
        elemkey:        "ip"
    },
    {
	id:		FV_ID_LOG_SNMP_TRAP_COMMUNITY,
	cfgkey:		"snmp.trap.dest[%I]",
        elemkey:        "community"
    }
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
log_snmp_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_LOG_SNMP, ACL_OBJ_LOG_S);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    if (strcmp(fh->fv[FV_ID_LOG_SNMP_ENABLED].val.s, "yes")) {
	fh_disable_validate_and_save(fh, FV_ID_LOG_SNMP_ENABLED);
    }
    return 0;
}

