#include <liberic_net.h>
#include <pp/cfg.h>
#include <pp/intl.h>
#include <liberic_cron.h>
#include <oem/eric_fw_oem.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"
#include "reconf.h"

#ifdef PP_FEAT_DYNDNS

FV_SPEC = {
    {
	id:		FV_ID_NET_DYNDNS_ENABLED,
	cfgkey:		"dyndns.enabled"
    },
    {
	id:		FV_ID_NET_DYNDNS_SYSTEM,
	cfgkey:		"dyndns.system",
    },
    {
	id:		FV_ID_NET_DYNDNS_SERVER,
	cfgkey:		"dyndns.server"
    },
    {
	id:		FV_ID_NET_DYNDNS_USER,
	cfgkey:		"dyndns.username"
    },
    {
	id:		FV_ID_NET_DYNDNS_PASSWORD,
	cfgkey:		"dyndns.password"
    },
    {
	id:		FV_ID_NET_DYNDNS_HOST,
	cfgkey:		"dyndns.hostname"
    },
    {
	id:		FV_ID_NET_DYNDNS_CHECK_TIME,
	cfgkey:		"dyndns.check_time"
    },
    {
	id:		FV_ID_NET_DYNDNS_CHECK_INTERVAL,
	cfgkey:		"dyndns.check_interval"
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
net_dyndns_tmpl_init(void)
{
    form_handler_t * fh;
    pp_cfg_chg_ctx_t ctx;

    srandom(time(NULL));
    ctx.retstr = NULL;
    ctx.tx = NULL;
    reconf_dyndns_ch(&ctx);

    fh = CREATE_FH_INSTANCE(TEMPLATE_NET_DYNDNS, ACL_OBJ_NET);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);

    return 0;
}

static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    if (form_button_clicked(wp, "action_dyndns_delete")) {
	dyndns_save_ip("");
	set_response(wp, ERIC_RESPONSE_OK, _("Saved external IP deleted"));
    } else if (strcmp(fh->fv[FV_ID_NET_DYNDNS_ENABLED].val.s, "yes")) {
	fh_disable_validate_and_save(fh, FV_ID_NET_DYNDNS_ENABLED);
    }
    return 0;
}

#else /* !PP_FEAT_DYNDNS */

int net_dyndns_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_DYNDNS */
