#include <liberic_net.h>
#include <liberic_misc.h>
#include <pp/setup_proto.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"

FV_SPEC = {
#ifdef PP_FEAT_PORT_CHANGE
    {
	id:		FV_ID_NET_HTTPS_PORT,
	cfgkey:		"network.https_port"
    },
    {
	id:		FV_ID_NET_HTTP_PORT,
	cfgkey:		"network.http_port"
    },
#if defined (PP_FEAT_RDM_SUPPORT)
    {
	id:		FV_ID_NET_DISCOVERY_PORT,
	cfgkey:		"network.discovery_port"
    },
#endif /* PP_FEAT_RDM_SUPPORT */
#ifdef PP_FEAT_TELNET
    {
	id:		FV_ID_NET_TELNET_PORT,
	cfgkey:		"network.telnet_port"
    },
#endif /* PP_FEAT_TELNET */
#ifdef PP_FEAT_SSH
    {
	id:		FV_ID_NET_SSH_PORT,
	cfgkey:		"network.ssh_port"
    },
#endif /* PP_FEAT_SSH */
#ifdef PP_FEAT_TERMINAL_SERVER
    {
	id:		FV_ID_NET_TERMSRV_BASEPORT,
	cfgkey:		"network.termsrv_baseport"
    },
#endif /* PP_FEAT_TERMINAL_SERVER */
#endif /* PP_FEAT_PORT_CHANGE */
#ifdef PP_FEAT_BANDWIDTH_LIMIT
    {
	id:		FV_ID_NET_TRAFFIC_RATE,
	cfgkey:		"network.traffic_rate"
    },
#endif /* PP_FEAT_BANDWIDTH_LIMIT */
#ifdef PP_FEAT_TELNET
    {
	id:		FV_ID_NET_TELNET_ENABLED,
	cfgkey:		"network.telnet_enabled",
    },
#endif /* PP_FEAT_TELNET */
#ifdef PP_FEAT_SSH
    {
	id:		FV_ID_NET_SSH_ENABLED,
	cfgkey:		"network.ssh_enabled",
    },
#endif /* PP_FEAT_SSH */
#ifdef PP_FEAT_TERMINAL_SERVER
    {
	id:		FV_ID_NET_TERMSRV_ENABLED,
	cfgkey:		"network.termsrv_enabled",
    },
#endif /* PP_FEAT_TERMINAL_SERVER */
#ifdef PP_FEAT_PEMX
    {
	id:		FV_ID_NET_DISABLE_NORBOX_SUPPORT,
	cfgkey:		"network.dp.disabled"
    },
#endif /* PP_FEAT_PEMX */
#ifdef PP_FEAT_CAN_SET_SETUP_PROTO
    {
	id:		FV_ID_NET_DISABLE_SETUP_PROTO,
	cfgkey:		"network.disable_setup_proto"
    },
#endif /* PP_FEAT_CAN_SET_SETUP_PROTO */
};

static int post_validate_hook(webs_t wp, form_handler_t * fh);

int
net_misc_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_NET_MISC, ACL_OBJ_NET);

    fh->post_validate_hook = post_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
post_validate_hook(webs_t wp,  form_handler_t * fh UNUSED)
{
#ifdef PP_FEAT_PORT_CHANGE
    return net_common_check_ports(wp);
#else
    (void)wp;
    return 0;
#endif
}
