#include <sys/time.h>
#include <liberic_net.h>
#include <liberic_misc.h>
#include "eric_base.h"
#include "eric_util.h"
#include "eric_validate.h"
#include "eric_forms.h"
#include "eric_form_vars.h"

#ifdef PP_FEAT_WLAN

FV_SPEC = {
    {
	id:		FV_ID_NET_WLAN_WPA_PSK_ENABLED,
	cfgkey:		"wlan.security_type.WPA.psk.enabled"
    },
    {
	id:		FV_ID_NET_WLAN_WPA_PSK_KEY,
	cfgkey:		"wlan.security_type.WPA.psk.key"
    },
};

static int pre_validate_hook(webs_t wp, form_handler_t * fh);

int
net_wlan_wpa_psk_tmpl_init(void)
{
    form_handler_t * fh;

    fh = CREATE_FH_INSTANCE(TEMPLATE_NET_WLAN_WPA_PSK, ACL_OBJ_NET);

    fh->pre_validate_hook = pre_validate_hook;

    REGISTER_FH_INSTANCE_AND_RETURN(fh);
}

static int
pre_validate_hook(webs_t wp UNUSED, form_handler_t * fh)
{
    if (strcmp(fh->fv[FV_ID_NET_WLAN_WPA_PSK_ENABLED].val.s, "yes")) {
	fh_disable_validate_and_save(fh, FV_ID_NET_WLAN_WPA_PSK_ENABLED);
    }
    return 0;
}

#else /* !PP_FEAT_WLAN */

int net_wlan_wpa_psk_tmpl_init(void) { return 0; }

#endif /* !PP_FEAT_WLAN */
